// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package fwcenter

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAddAddressBookCommon = "AddAddressBook"

// AddAddressBookCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AddAddressBookCommon operation. The "output" return
// value will be populated with the AddAddressBookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AddAddressBookCommon Request to send the API call to the service.
// the "output" return value is not valid until after AddAddressBookCommon Send returns without error.
//
// See AddAddressBookCommon for more information on using the AddAddressBookCommon
// API call, and error handling.
//
//    // Example sending a request using the AddAddressBookCommonRequest method.
//    req, resp := client.AddAddressBookCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) AddAddressBookCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAddAddressBookCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AddAddressBookCommon API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation AddAddressBookCommon for usage and error information.
func (c *FWCENTER) AddAddressBookCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AddAddressBookCommonRequest(input)
	return out, req.Send()
}

// AddAddressBookCommonWithContext is the same as AddAddressBookCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AddAddressBookCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) AddAddressBookCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AddAddressBookCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddAddressBook = "AddAddressBook"

// AddAddressBookRequest generates a "volcengine/request.Request" representing the
// client's request for the AddAddressBook operation. The "output" return
// value will be populated with the AddAddressBookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AddAddressBookCommon Request to send the API call to the service.
// the "output" return value is not valid until after AddAddressBookCommon Send returns without error.
//
// See AddAddressBook for more information on using the AddAddressBook
// API call, and error handling.
//
//    // Example sending a request using the AddAddressBookRequest method.
//    req, resp := client.AddAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) AddAddressBookRequest(input *AddAddressBookInput) (req *request.Request, output *AddAddressBookOutput) {
	op := &request.Operation{
		Name:       opAddAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAddressBookInput{}
	}

	output = &AddAddressBookOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AddAddressBook API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation AddAddressBook for usage and error information.
func (c *FWCENTER) AddAddressBook(input *AddAddressBookInput) (*AddAddressBookOutput, error) {
	req, out := c.AddAddressBookRequest(input)
	return out, req.Send()
}

// AddAddressBookWithContext is the same as AddAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See AddAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) AddAddressBookWithContext(ctx volcengine.Context, input *AddAddressBookInput, opts ...request.Option) (*AddAddressBookOutput, error) {
	req, out := c.AddAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddAddressBookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddressDetailList []*AddressDetailListForAddAddressBookInput `type:"list" json:",omitempty"`

	AddressList []*string `type:"list" json:",omitempty"`

	AutoUpdateType *string `type:"string" json:",omitempty" enum:"EnumOfAutoUpdateTypeForAddAddressBookInput"`

	CloudFirewallId *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	// GroupName is a required field
	GroupName *string `max:"64" type:"string" json:",omitempty" required:"true"`

	// GroupType is a required field
	GroupType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfGroupTypeForAddAddressBookInput"`

	InstanceTypeList []*string `type:"list" json:",omitempty"`

	ResourceType *string `type:"string" json:",omitempty" enum:"EnumOfResourceTypeForAddAddressBookInput"`

	TagRelation *string `type:"string" json:",omitempty" enum:"EnumOfTagRelationForAddAddressBookInput"`

	Tags []*TagForAddAddressBookInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s AddAddressBookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddAddressBookInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("GroupName", 64, *s.GroupName))
	}
	if s.GroupType == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupType"))
	}
	if s.AddressDetailList != nil {
		for i, v := range s.AddressDetailList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddressDetailList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressDetailList sets the AddressDetailList field's value.
func (s *AddAddressBookInput) SetAddressDetailList(v []*AddressDetailListForAddAddressBookInput) *AddAddressBookInput {
	s.AddressDetailList = v
	return s
}

// SetAddressList sets the AddressList field's value.
func (s *AddAddressBookInput) SetAddressList(v []*string) *AddAddressBookInput {
	s.AddressList = v
	return s
}

// SetAutoUpdateType sets the AutoUpdateType field's value.
func (s *AddAddressBookInput) SetAutoUpdateType(v string) *AddAddressBookInput {
	s.AutoUpdateType = &v
	return s
}

// SetCloudFirewallId sets the CloudFirewallId field's value.
func (s *AddAddressBookInput) SetCloudFirewallId(v string) *AddAddressBookInput {
	s.CloudFirewallId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddAddressBookInput) SetDescription(v string) *AddAddressBookInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AddAddressBookInput) SetGroupName(v string) *AddAddressBookInput {
	s.GroupName = &v
	return s
}

// SetGroupType sets the GroupType field's value.
func (s *AddAddressBookInput) SetGroupType(v string) *AddAddressBookInput {
	s.GroupType = &v
	return s
}

// SetInstanceTypeList sets the InstanceTypeList field's value.
func (s *AddAddressBookInput) SetInstanceTypeList(v []*string) *AddAddressBookInput {
	s.InstanceTypeList = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AddAddressBookInput) SetResourceType(v string) *AddAddressBookInput {
	s.ResourceType = &v
	return s
}

// SetTagRelation sets the TagRelation field's value.
func (s *AddAddressBookInput) SetTagRelation(v string) *AddAddressBookInput {
	s.TagRelation = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddAddressBookInput) SetTags(v []*TagForAddAddressBookInput) *AddAddressBookInput {
	s.Tags = v
	return s
}

type AddAddressBookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	GroupUuid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AddAddressBookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAddressBookOutput) GoString() string {
	return s.String()
}

// SetGroupUuid sets the GroupUuid field's value.
func (s *AddAddressBookOutput) SetGroupUuid(v string) *AddAddressBookOutput {
	s.GroupUuid = &v
	return s
}

type AddressDetailListForAddAddressBookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	Description *string `max:"32" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AddressDetailListForAddAddressBookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressDetailListForAddAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddressDetailListForAddAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddressDetailListForAddAddressBookInput"}
	if s.Description != nil && len(*s.Description) > 32 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 32, *s.Description))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *AddressDetailListForAddAddressBookInput) SetAddress(v string) *AddressDetailListForAddAddressBookInput {
	s.Address = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddressDetailListForAddAddressBookInput) SetDescription(v string) *AddressDetailListForAddAddressBookInput {
	s.Description = &v
	return s
}

type TagForAddAddressBookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `min:"1" max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForAddAddressBookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForAddAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForAddAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForAddAddressBookInput"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}
	if s.Value != nil && len(*s.Value) > 256 {
		invalidParams.Add(request.NewErrParamMaxLen("Value", 256, *s.Value))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForAddAddressBookInput) SetKey(v string) *TagForAddAddressBookInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForAddAddressBookInput) SetValue(v string) *TagForAddAddressBookInput {
	s.Value = &v
	return s
}

const (
	// EnumOfAutoUpdateTypeForAddAddressBookInputManual is a EnumOfAutoUpdateTypeForAddAddressBookInput enum value
	EnumOfAutoUpdateTypeForAddAddressBookInputManual = "Manual"

	// EnumOfAutoUpdateTypeForAddAddressBookInputTag is a EnumOfAutoUpdateTypeForAddAddressBookInput enum value
	EnumOfAutoUpdateTypeForAddAddressBookInputTag = "Tag"
)

const (
	// EnumOfGroupTypeForAddAddressBookInputIp is a EnumOfGroupTypeForAddAddressBookInput enum value
	EnumOfGroupTypeForAddAddressBookInputIp = "ip"

	// EnumOfGroupTypeForAddAddressBookInputIpv6 is a EnumOfGroupTypeForAddAddressBookInput enum value
	EnumOfGroupTypeForAddAddressBookInputIpv6 = "ipv6"

	// EnumOfGroupTypeForAddAddressBookInputDomain is a EnumOfGroupTypeForAddAddressBookInput enum value
	EnumOfGroupTypeForAddAddressBookInputDomain = "domain"

	// EnumOfGroupTypeForAddAddressBookInputPort is a EnumOfGroupTypeForAddAddressBookInput enum value
	EnumOfGroupTypeForAddAddressBookInputPort = "port"
)

const (
	// EnumOfResourceTypeForAddAddressBookInputEip is a EnumOfResourceTypeForAddAddressBookInput enum value
	EnumOfResourceTypeForAddAddressBookInputEip = "Eip"

	// EnumOfResourceTypeForAddAddressBookInputInternetAsset is a EnumOfResourceTypeForAddAddressBookInput enum value
	EnumOfResourceTypeForAddAddressBookInputInternetAsset = "InternetAsset"
)

const (
	// EnumOfTagRelationForAddAddressBookInputAnd is a EnumOfTagRelationForAddAddressBookInput enum value
	EnumOfTagRelationForAddAddressBookInputAnd = "And"

	// EnumOfTagRelationForAddAddressBookInputOr is a EnumOfTagRelationForAddAddressBookInput enum value
	EnumOfTagRelationForAddAddressBookInputOr = "Or"
)
