// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package escloud

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRestartNodeCommon = "RestartNode"

// RestartNodeCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RestartNodeCommon operation. The "output" return
// value will be populated with the RestartNodeCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RestartNodeCommon Request to send the API call to the service.
// the "output" return value is not valid until after RestartNodeCommon Send returns without error.
//
// See RestartNodeCommon for more information on using the RestartNodeCommon
// API call, and error handling.
//
//    // Example sending a request using the RestartNodeCommonRequest method.
//    req, resp := client.RestartNodeCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) RestartNodeCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRestartNodeCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RestartNodeCommon API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation RestartNodeCommon for usage and error information.
func (c *ESCLOUD) RestartNodeCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RestartNodeCommonRequest(input)
	return out, req.Send()
}

// RestartNodeCommonWithContext is the same as RestartNodeCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RestartNodeCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) RestartNodeCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RestartNodeCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestartNode = "RestartNode"

// RestartNodeRequest generates a "volcengine/request.Request" representing the
// client's request for the RestartNode operation. The "output" return
// value will be populated with the RestartNodeCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RestartNodeCommon Request to send the API call to the service.
// the "output" return value is not valid until after RestartNodeCommon Send returns without error.
//
// See RestartNode for more information on using the RestartNode
// API call, and error handling.
//
//    // Example sending a request using the RestartNodeRequest method.
//    req, resp := client.RestartNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) RestartNodeRequest(input *RestartNodeInput) (req *request.Request, output *RestartNodeOutput) {
	op := &request.Operation{
		Name:       opRestartNode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestartNodeInput{}
	}

	output = &RestartNodeOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RestartNode API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation RestartNode for usage and error information.
func (c *ESCLOUD) RestartNode(input *RestartNodeInput) (*RestartNodeOutput, error) {
	req, out := c.RestartNodeRequest(input)
	return out, req.Send()
}

// RestartNodeWithContext is the same as RestartNode with the addition of
// the ability to pass a context and additional request options.
//
// See RestartNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) RestartNodeWithContext(ctx volcengine.Context, input *RestartNodeInput, opts ...request.Option) (*RestartNodeOutput, error) {
	req, out := c.RestartNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type RestartNodeInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Force *bool `type:"boolean" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// NodeName is a required field
	NodeName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s RestartNodeInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RestartNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestartNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestartNodeInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.NodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *RestartNodeInput) SetForce(v bool) *RestartNodeInput {
	s.Force = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *RestartNodeInput) SetInstanceId(v string) *RestartNodeInput {
	s.InstanceId = &v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *RestartNodeInput) SetNodeName(v string) *RestartNodeInput {
	s.NodeName = &v
	return s
}

type RestartNodeOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	NodeName *string `type:"string" json:",omitempty"`

	TaskId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RestartNodeOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RestartNodeOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *RestartNodeOutput) SetInstanceId(v string) *RestartNodeOutput {
	s.InstanceId = &v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *RestartNodeOutput) SetNodeName(v string) *RestartNodeOutput {
	s.NodeName = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *RestartNodeOutput) SetTaskId(v string) *RestartNodeOutput {
	s.TaskId = &v
	return s
}
