// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opScaleOutNodeGroupCommon = "ScaleOutNodeGroup"

// ScaleOutNodeGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ScaleOutNodeGroupCommon operation. The "output" return
// value will be populated with the ScaleOutNodeGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ScaleOutNodeGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after ScaleOutNodeGroupCommon Send returns without error.
//
// See ScaleOutNodeGroupCommon for more information on using the ScaleOutNodeGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the ScaleOutNodeGroupCommonRequest method.
//    req, resp := client.ScaleOutNodeGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ScaleOutNodeGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opScaleOutNodeGroupCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ScaleOutNodeGroupCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ScaleOutNodeGroupCommon for usage and error information.
func (c *EMR) ScaleOutNodeGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ScaleOutNodeGroupCommonRequest(input)
	return out, req.Send()
}

// ScaleOutNodeGroupCommonWithContext is the same as ScaleOutNodeGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ScaleOutNodeGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ScaleOutNodeGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ScaleOutNodeGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opScaleOutNodeGroup = "ScaleOutNodeGroup"

// ScaleOutNodeGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the ScaleOutNodeGroup operation. The "output" return
// value will be populated with the ScaleOutNodeGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ScaleOutNodeGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after ScaleOutNodeGroupCommon Send returns without error.
//
// See ScaleOutNodeGroup for more information on using the ScaleOutNodeGroup
// API call, and error handling.
//
//    // Example sending a request using the ScaleOutNodeGroupRequest method.
//    req, resp := client.ScaleOutNodeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ScaleOutNodeGroupRequest(input *ScaleOutNodeGroupInput) (req *request.Request, output *ScaleOutNodeGroupOutput) {
	op := &request.Operation{
		Name:       opScaleOutNodeGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScaleOutNodeGroupInput{}
	}

	output = &ScaleOutNodeGroupOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ScaleOutNodeGroup API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ScaleOutNodeGroup for usage and error information.
func (c *EMR) ScaleOutNodeGroup(input *ScaleOutNodeGroupInput) (*ScaleOutNodeGroupOutput, error) {
	req, out := c.ScaleOutNodeGroupRequest(input)
	return out, req.Send()
}

// ScaleOutNodeGroupWithContext is the same as ScaleOutNodeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ScaleOutNodeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ScaleOutNodeGroupWithContext(ctx volcengine.Context, input *ScaleOutNodeGroupInput, opts ...request.Option) (*ScaleOutNodeGroupOutput, error) {
	req, out := c.ScaleOutNodeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ResultDataForScaleOutNodeGroupOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ResultDataForScaleOutNodeGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultDataForScaleOutNodeGroupOutput) GoString() string {
	return s.String()
}

type ScaleOutNodeGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	// NodeGroupId is a required field
	NodeGroupId *string `type:"string" json:",omitempty" required:"true"`

	// ScaleOutNodeCount is a required field
	ScaleOutNodeCount *int32 `min:"1" max:"1000" type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ScaleOutNodeGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ScaleOutNodeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScaleOutNodeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScaleOutNodeGroupInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.NodeGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeGroupId"))
	}
	if s.ScaleOutNodeCount == nil {
		invalidParams.Add(request.NewErrParamRequired("ScaleOutNodeCount"))
	}
	if s.ScaleOutNodeCount != nil && *s.ScaleOutNodeCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ScaleOutNodeCount", 1))
	}
	if s.ScaleOutNodeCount != nil && *s.ScaleOutNodeCount > 1000 {
		invalidParams.Add(request.NewErrParamMaxValue("ScaleOutNodeCount", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ScaleOutNodeGroupInput) SetClientToken(v string) *ScaleOutNodeGroupInput {
	s.ClientToken = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ScaleOutNodeGroupInput) SetClusterId(v string) *ScaleOutNodeGroupInput {
	s.ClusterId = &v
	return s
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *ScaleOutNodeGroupInput) SetNodeGroupId(v string) *ScaleOutNodeGroupInput {
	s.NodeGroupId = &v
	return s
}

// SetScaleOutNodeCount sets the ScaleOutNodeCount field's value.
func (s *ScaleOutNodeGroupInput) SetScaleOutNodeCount(v int32) *ScaleOutNodeGroupInput {
	s.ScaleOutNodeCount = &v
	return s
}

type ScaleOutNodeGroupOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ClusterId *string `type:"string" json:",omitempty"`

	OperationId *string `type:"string" json:",omitempty"`

	ResultData *ResultDataForScaleOutNodeGroupOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ScaleOutNodeGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ScaleOutNodeGroupOutput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *ScaleOutNodeGroupOutput) SetClusterId(v string) *ScaleOutNodeGroupOutput {
	s.ClusterId = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *ScaleOutNodeGroupOutput) SetOperationId(v string) *ScaleOutNodeGroupOutput {
	s.OperationId = &v
	return s
}

// SetResultData sets the ResultData field's value.
func (s *ScaleOutNodeGroupOutput) SetResultData(v *ResultDataForScaleOutNodeGroupOutput) *ScaleOutNodeGroupOutput {
	s.ResultData = v
	return s
}
