// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListApplicationsCommon = "ListApplications"

// ListApplicationsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListApplicationsCommon operation. The "output" return
// value will be populated with the ListApplicationsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListApplicationsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListApplicationsCommon Send returns without error.
//
// See ListApplicationsCommon for more information on using the ListApplicationsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListApplicationsCommonRequest method.
//    req, resp := client.ListApplicationsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ListApplicationsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListApplicationsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListApplicationsCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ListApplicationsCommon for usage and error information.
func (c *EMR) ListApplicationsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListApplicationsCommonRequest(input)
	return out, req.Send()
}

// ListApplicationsCommonWithContext is the same as ListApplicationsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListApplicationsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListApplicationsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the ListApplicationsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListApplicationsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListApplicationsCommon Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListApplications API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ListApplications for usage and error information.
func (c *EMR) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListApplicationsWithContext(ctx volcengine.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ItemForListApplicationsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationConfigHome *string `type:"string" json:",omitempty"`

	ApplicationHome *string `type:"string" json:",omitempty"`

	ApplicationName *string `type:"string" json:",omitempty"`

	ApplicationState *string `type:"string" json:",omitempty"`

	ApplicationVersion *string `type:"string" json:",omitempty"`

	Group *string `type:"string" json:",omitempty"`

	SupportClient *bool `type:"boolean" json:",omitempty"`

	User *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListApplicationsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplicationConfigHome sets the ApplicationConfigHome field's value.
func (s *ItemForListApplicationsOutput) SetApplicationConfigHome(v string) *ItemForListApplicationsOutput {
	s.ApplicationConfigHome = &v
	return s
}

// SetApplicationHome sets the ApplicationHome field's value.
func (s *ItemForListApplicationsOutput) SetApplicationHome(v string) *ItemForListApplicationsOutput {
	s.ApplicationHome = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ItemForListApplicationsOutput) SetApplicationName(v string) *ItemForListApplicationsOutput {
	s.ApplicationName = &v
	return s
}

// SetApplicationState sets the ApplicationState field's value.
func (s *ItemForListApplicationsOutput) SetApplicationState(v string) *ItemForListApplicationsOutput {
	s.ApplicationState = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *ItemForListApplicationsOutput) SetApplicationVersion(v string) *ItemForListApplicationsOutput {
	s.ApplicationVersion = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *ItemForListApplicationsOutput) SetGroup(v string) *ItemForListApplicationsOutput {
	s.Group = &v
	return s
}

// SetSupportClient sets the SupportClient field's value.
func (s *ItemForListApplicationsOutput) SetSupportClient(v bool) *ItemForListApplicationsOutput {
	s.SupportClient = &v
	return s
}

// SetUser sets the User field's value.
func (s *ItemForListApplicationsOutput) SetUser(v string) *ItemForListApplicationsOutput {
	s.User = &v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationNames []*string `type:"list" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	MaxResults *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	NextToken *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MaxResults != nil && *s.MaxResults > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("MaxResults", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationNames sets the ApplicationNames field's value.
func (s *ListApplicationsInput) SetApplicationNames(v []*string) *ListApplicationsInput {
	s.ApplicationNames = v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ListApplicationsInput) SetClusterId(v string) *ListApplicationsInput {
	s.ClusterId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int32) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListApplicationsOutput `type:"list" json:",omitempty"`

	MaxResults *int32 `type:"int32" json:",omitempty"`

	NextToken *string `type:"string" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListApplicationsOutput) SetItems(v []*ItemForListApplicationsOutput) *ListApplicationsOutput {
	s.Items = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsOutput) SetMaxResults(v int32) *ListApplicationsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListApplicationsOutput) SetTotalCount(v int32) *ListApplicationsOutput {
	s.TotalCount = &v
	return s
}
