// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package edx

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetDXPConnectionCommon = "GetDXPConnection"

// GetDXPConnectionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetDXPConnectionCommon operation. The "output" return
// value will be populated with the GetDXPConnectionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetDXPConnectionCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetDXPConnectionCommon Send returns without error.
//
// See GetDXPConnectionCommon for more information on using the GetDXPConnectionCommon
// API call, and error handling.
//
//    // Example sending a request using the GetDXPConnectionCommonRequest method.
//    req, resp := client.GetDXPConnectionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EDX) GetDXPConnectionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetDXPConnectionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetDXPConnectionCommon API operation for EDX.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EDX's
// API operation GetDXPConnectionCommon for usage and error information.
func (c *EDX) GetDXPConnectionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetDXPConnectionCommonRequest(input)
	return out, req.Send()
}

// GetDXPConnectionCommonWithContext is the same as GetDXPConnectionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetDXPConnectionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EDX) GetDXPConnectionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetDXPConnectionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDXPConnection = "GetDXPConnection"

// GetDXPConnectionRequest generates a "volcengine/request.Request" representing the
// client's request for the GetDXPConnection operation. The "output" return
// value will be populated with the GetDXPConnectionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetDXPConnectionCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetDXPConnectionCommon Send returns without error.
//
// See GetDXPConnection for more information on using the GetDXPConnection
// API call, and error handling.
//
//    // Example sending a request using the GetDXPConnectionRequest method.
//    req, resp := client.GetDXPConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EDX) GetDXPConnectionRequest(input *GetDXPConnectionInput) (req *request.Request, output *GetDXPConnectionOutput) {
	op := &request.Operation{
		Name:       opGetDXPConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDXPConnectionInput{}
	}

	output = &GetDXPConnectionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetDXPConnection API operation for EDX.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EDX's
// API operation GetDXPConnection for usage and error information.
func (c *EDX) GetDXPConnection(input *GetDXPConnectionInput) (*GetDXPConnectionOutput, error) {
	req, out := c.GetDXPConnectionRequest(input)
	return out, req.Send()
}

// GetDXPConnectionWithContext is the same as GetDXPConnection with the addition of
// the ability to pass a context and additional request options.
//
// See GetDXPConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EDX) GetDXPConnectionWithContext(ctx volcengine.Context, input *GetDXPConnectionInput, opts ...request.Option) (*GetDXPConnectionOutput, error) {
	req, out := c.GetDXPConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConnectionInfoForGetDXPConnectionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *string `type:"string" json:",omitempty"`

	ContactName *string `type:"string" json:",omitempty"`

	ContactPhone *string `type:"string" json:",omitempty"`

	FieldEngineer []*FieldEngineerForGetDXPConnectionOutput `type:"list" json:",omitempty"`

	IDCAddr *string `type:"string" json:",omitempty"`

	IDCCode *string `type:"string" json:",omitempty"`

	IDCLocation *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConnectionInfoForGetDXPConnectionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionInfoForGetDXPConnectionOutput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *ConnectionInfoForGetDXPConnectionOutput) SetBandwidth(v string) *ConnectionInfoForGetDXPConnectionOutput {
	s.Bandwidth = &v
	return s
}

// SetContactName sets the ContactName field's value.
func (s *ConnectionInfoForGetDXPConnectionOutput) SetContactName(v string) *ConnectionInfoForGetDXPConnectionOutput {
	s.ContactName = &v
	return s
}

// SetContactPhone sets the ContactPhone field's value.
func (s *ConnectionInfoForGetDXPConnectionOutput) SetContactPhone(v string) *ConnectionInfoForGetDXPConnectionOutput {
	s.ContactPhone = &v
	return s
}

// SetFieldEngineer sets the FieldEngineer field's value.
func (s *ConnectionInfoForGetDXPConnectionOutput) SetFieldEngineer(v []*FieldEngineerForGetDXPConnectionOutput) *ConnectionInfoForGetDXPConnectionOutput {
	s.FieldEngineer = v
	return s
}

// SetIDCAddr sets the IDCAddr field's value.
func (s *ConnectionInfoForGetDXPConnectionOutput) SetIDCAddr(v string) *ConnectionInfoForGetDXPConnectionOutput {
	s.IDCAddr = &v
	return s
}

// SetIDCCode sets the IDCCode field's value.
func (s *ConnectionInfoForGetDXPConnectionOutput) SetIDCCode(v string) *ConnectionInfoForGetDXPConnectionOutput {
	s.IDCCode = &v
	return s
}

// SetIDCLocation sets the IDCLocation field's value.
func (s *ConnectionInfoForGetDXPConnectionOutput) SetIDCLocation(v string) *ConnectionInfoForGetDXPConnectionOutput {
	s.IDCLocation = &v
	return s
}

type FieldEngineerForGetDXPConnectionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FieldEngineerForGetDXPConnectionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldEngineerForGetDXPConnectionOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FieldEngineerForGetDXPConnectionOutput) SetName(v string) *FieldEngineerForGetDXPConnectionOutput {
	s.Name = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *FieldEngineerForGetDXPConnectionOutput) SetPhone(v string) *FieldEngineerForGetDXPConnectionOutput {
	s.Phone = &v
	return s
}

type GetDXPConnectionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetDXPConnectionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDXPConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDXPConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDXPConnectionInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetDXPConnectionInput) SetInstanceId(v string) *GetDXPConnectionInput {
	s.InstanceId = &v
	return s
}

type GetDXPConnectionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ConnectionInfo *ConnectionInfoForGetDXPConnectionOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s GetDXPConnectionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDXPConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionInfo sets the ConnectionInfo field's value.
func (s *GetDXPConnectionOutput) SetConnectionInfo(v *ConnectionInfoForGetDXPConnectionOutput) *GetDXPConnectionOutput {
	s.ConnectionInfo = v
	return s
}
