// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package edx

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDXPConnectionCommon = "CreateDXPConnection"

// CreateDXPConnectionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDXPConnectionCommon operation. The "output" return
// value will be populated with the CreateDXPConnectionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDXPConnectionCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDXPConnectionCommon Send returns without error.
//
// See CreateDXPConnectionCommon for more information on using the CreateDXPConnectionCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDXPConnectionCommonRequest method.
//    req, resp := client.CreateDXPConnectionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EDX) CreateDXPConnectionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDXPConnectionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDXPConnectionCommon API operation for EDX.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EDX's
// API operation CreateDXPConnectionCommon for usage and error information.
func (c *EDX) CreateDXPConnectionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDXPConnectionCommonRequest(input)
	return out, req.Send()
}

// CreateDXPConnectionCommonWithContext is the same as CreateDXPConnectionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDXPConnectionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EDX) CreateDXPConnectionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDXPConnectionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDXPConnection = "CreateDXPConnection"

// CreateDXPConnectionRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDXPConnection operation. The "output" return
// value will be populated with the CreateDXPConnectionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDXPConnectionCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDXPConnectionCommon Send returns without error.
//
// See CreateDXPConnection for more information on using the CreateDXPConnection
// API call, and error handling.
//
//    // Example sending a request using the CreateDXPConnectionRequest method.
//    req, resp := client.CreateDXPConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EDX) CreateDXPConnectionRequest(input *CreateDXPConnectionInput) (req *request.Request, output *CreateDXPConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateDXPConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDXPConnectionInput{}
	}

	output = &CreateDXPConnectionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDXPConnection API operation for EDX.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EDX's
// API operation CreateDXPConnection for usage and error information.
func (c *EDX) CreateDXPConnection(input *CreateDXPConnectionInput) (*CreateDXPConnectionOutput, error) {
	req, out := c.CreateDXPConnectionRequest(input)
	return out, req.Send()
}

// CreateDXPConnectionWithContext is the same as CreateDXPConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDXPConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EDX) CreateDXPConnectionWithContext(ctx volcengine.Context, input *CreateDXPConnectionInput, opts ...request.Option) (*CreateDXPConnectionOutput, error) {
	req, out := c.CreateDXPConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateDXPConnectionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Bandwidth is a required field
	Bandwidth *string `type:"string" json:",omitempty" required:"true"`

	// ContactName is a required field
	ContactName *string `type:"string" json:",omitempty" required:"true"`

	// ContactPhone is a required field
	ContactPhone *string `type:"string" json:",omitempty" required:"true"`

	FieldEngineer []*FieldEngineerForCreateDXPConnectionInput `type:"list" json:",omitempty"`

	// IDCAddr is a required field
	IDCAddr *string `type:"string" json:",omitempty" required:"true"`

	// IDCCode is a required field
	IDCCode *string `type:"string" json:",omitempty" required:"true"`

	// IDCLocation is a required field
	IDCLocation *string `type:"string" json:",omitempty" required:"true"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// LicenseURL is a required field
	LicenseURL *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateDXPConnectionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDXPConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDXPConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDXPConnectionInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ContactName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactName"))
	}
	if s.ContactPhone == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactPhone"))
	}
	if s.IDCAddr == nil {
		invalidParams.Add(request.NewErrParamRequired("IDCAddr"))
	}
	if s.IDCCode == nil {
		invalidParams.Add(request.NewErrParamRequired("IDCCode"))
	}
	if s.IDCLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("IDCLocation"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.LicenseURL == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseURL"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *CreateDXPConnectionInput) SetBandwidth(v string) *CreateDXPConnectionInput {
	s.Bandwidth = &v
	return s
}

// SetContactName sets the ContactName field's value.
func (s *CreateDXPConnectionInput) SetContactName(v string) *CreateDXPConnectionInput {
	s.ContactName = &v
	return s
}

// SetContactPhone sets the ContactPhone field's value.
func (s *CreateDXPConnectionInput) SetContactPhone(v string) *CreateDXPConnectionInput {
	s.ContactPhone = &v
	return s
}

// SetFieldEngineer sets the FieldEngineer field's value.
func (s *CreateDXPConnectionInput) SetFieldEngineer(v []*FieldEngineerForCreateDXPConnectionInput) *CreateDXPConnectionInput {
	s.FieldEngineer = v
	return s
}

// SetIDCAddr sets the IDCAddr field's value.
func (s *CreateDXPConnectionInput) SetIDCAddr(v string) *CreateDXPConnectionInput {
	s.IDCAddr = &v
	return s
}

// SetIDCCode sets the IDCCode field's value.
func (s *CreateDXPConnectionInput) SetIDCCode(v string) *CreateDXPConnectionInput {
	s.IDCCode = &v
	return s
}

// SetIDCLocation sets the IDCLocation field's value.
func (s *CreateDXPConnectionInput) SetIDCLocation(v string) *CreateDXPConnectionInput {
	s.IDCLocation = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateDXPConnectionInput) SetInstanceId(v string) *CreateDXPConnectionInput {
	s.InstanceId = &v
	return s
}

// SetLicenseURL sets the LicenseURL field's value.
func (s *CreateDXPConnectionInput) SetLicenseURL(v string) *CreateDXPConnectionInput {
	s.LicenseURL = &v
	return s
}

type CreateDXPConnectionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s CreateDXPConnectionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDXPConnectionOutput) GoString() string {
	return s.String()
}

type FieldEngineerForCreateDXPConnectionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FieldEngineerForCreateDXPConnectionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldEngineerForCreateDXPConnectionInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FieldEngineerForCreateDXPConnectionInput) SetName(v string) *FieldEngineerForCreateDXPConnectionInput {
	s.Name = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *FieldEngineerForCreateDXPConnectionInput) SetPhone(v string) *FieldEngineerForCreateDXPConnectionInput {
	s.Phone = &v
	return s
}
