// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListDataMigrateTaskCommon = "ListDataMigrateTask"

// ListDataMigrateTaskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDataMigrateTaskCommon operation. The "output" return
// value will be populated with the ListDataMigrateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDataMigrateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDataMigrateTaskCommon Send returns without error.
//
// See ListDataMigrateTaskCommon for more information on using the ListDataMigrateTaskCommon
// API call, and error handling.
//
//    // Example sending a request using the ListDataMigrateTaskCommonRequest method.
//    req, resp := client.ListDataMigrateTaskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DMS) ListDataMigrateTaskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListDataMigrateTaskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDataMigrateTaskCommon API operation for DMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DMS's
// API operation ListDataMigrateTaskCommon for usage and error information.
func (c *DMS) ListDataMigrateTaskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListDataMigrateTaskCommonRequest(input)
	return out, req.Send()
}

// ListDataMigrateTaskCommonWithContext is the same as ListDataMigrateTaskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataMigrateTaskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DMS) ListDataMigrateTaskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListDataMigrateTaskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataMigrateTask = "ListDataMigrateTask"

// ListDataMigrateTaskRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDataMigrateTask operation. The "output" return
// value will be populated with the ListDataMigrateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDataMigrateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDataMigrateTaskCommon Send returns without error.
//
// See ListDataMigrateTask for more information on using the ListDataMigrateTask
// API call, and error handling.
//
//    // Example sending a request using the ListDataMigrateTaskRequest method.
//    req, resp := client.ListDataMigrateTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DMS) ListDataMigrateTaskRequest(input *ListDataMigrateTaskInput) (req *request.Request, output *ListDataMigrateTaskOutput) {
	op := &request.Operation{
		Name:       opListDataMigrateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDataMigrateTaskInput{}
	}

	output = &ListDataMigrateTaskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDataMigrateTask API operation for DMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DMS's
// API operation ListDataMigrateTask for usage and error information.
func (c *DMS) ListDataMigrateTask(input *ListDataMigrateTaskInput) (*ListDataMigrateTaskOutput, error) {
	req, out := c.ListDataMigrateTaskRequest(input)
	return out, req.Send()
}

// ListDataMigrateTaskWithContext is the same as ListDataMigrateTask with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataMigrateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DMS) ListDataMigrateTaskWithContext(ctx volcengine.Context, input *ListDataMigrateTaskInput, opts ...request.Option) (*ListDataMigrateTaskOutput, error) {
	req, out := c.ListDataMigrateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Limit *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	// Offset is a required field
	Offset *int32 `type:"int32" json:",omitempty" required:"true"`

	TaskStatus *string `type:"string" json:",omitempty" enum:"EnumOfTaskStatusForListDataMigrateTaskInput"`
}

// String returns the string representation
func (s ListDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataMigrateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataMigrateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataMigrateTaskInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Limit != nil && *s.Limit > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("Limit", 100))
	}
	if s.Offset == nil {
		invalidParams.Add(request.NewErrParamRequired("Offset"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListDataMigrateTaskInput) SetLimit(v int32) *ListDataMigrateTaskInput {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *ListDataMigrateTaskInput) SetOffset(v int32) *ListDataMigrateTaskInput {
	s.Offset = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *ListDataMigrateTaskInput) SetTaskStatus(v string) *ListDataMigrateTaskInput {
	s.TaskStatus = &v
	return s
}

type ListDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Count *int32 `type:"int32" json:",omitempty"`

	TaskList []*TaskListForListDataMigrateTaskOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ListDataMigrateTaskOutput) SetCount(v int32) *ListDataMigrateTaskOutput {
	s.Count = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *ListDataMigrateTaskOutput) SetTaskList(v []*TaskListForListDataMigrateTaskOutput) *ListDataMigrateTaskOutput {
	s.TaskList = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListDataMigrateTaskOutput) SetTotal(v int32) *ListDataMigrateTaskOutput {
	s.Total = &v
	return s
}

type TaskListForListDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	TaskID *int64 `type:"int64" json:",omitempty"`

	TaskName *string `type:"string" json:",omitempty"`

	TaskProgress *TaskProgressForListDataMigrateTaskOutput `type:"structure" json:",omitempty"`

	TaskStatus *string `type:"string" json:",omitempty" enum:"EnumOfTaskStatusForListDataMigrateTaskOutput"`
}

// String returns the string representation
func (s TaskListForListDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskListForListDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *TaskListForListDataMigrateTaskOutput) SetCreateTime(v string) *TaskListForListDataMigrateTaskOutput {
	s.CreateTime = &v
	return s
}

// SetTaskID sets the TaskID field's value.
func (s *TaskListForListDataMigrateTaskOutput) SetTaskID(v int64) *TaskListForListDataMigrateTaskOutput {
	s.TaskID = &v
	return s
}

// SetTaskName sets the TaskName field's value.
func (s *TaskListForListDataMigrateTaskOutput) SetTaskName(v string) *TaskListForListDataMigrateTaskOutput {
	s.TaskName = &v
	return s
}

// SetTaskProgress sets the TaskProgress field's value.
func (s *TaskListForListDataMigrateTaskOutput) SetTaskProgress(v *TaskProgressForListDataMigrateTaskOutput) *TaskListForListDataMigrateTaskOutput {
	s.TaskProgress = v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *TaskListForListDataMigrateTaskOutput) SetTaskStatus(v string) *TaskListForListDataMigrateTaskOutput {
	s.TaskStatus = &v
	return s
}

type TaskProgressForListDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FailedBytes *int64 `type:"int64" json:",omitempty"`

	FailedObjects *int64 `type:"int64" json:",omitempty"`

	NotExistBytes *int64 `type:"int64" json:",omitempty"`

	NotExistObjectCount *int64 `type:"int64" json:",omitempty"`

	RemainingBytes *int64 `type:"int64" json:",omitempty"`

	RemainingObjects *int64 `type:"int64" json:",omitempty"`

	SkipBytes *int64 `type:"int64" json:",omitempty"`

	SkipObjectCount *int64 `type:"int64" json:",omitempty"`

	TotalBytes *int64 `type:"int64" json:",omitempty"`

	TotalObjects *int64 `type:"int64" json:",omitempty"`

	TransferBytesSpeed *int64 `type:"int64" json:",omitempty"`

	TransferCountSpeed *int64 `type:"int64" json:",omitempty"`

	TransferredBytes *int64 `type:"int64" json:",omitempty"`

	TransferredObjects *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s TaskProgressForListDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskProgressForListDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetFailedBytes sets the FailedBytes field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetFailedBytes(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.FailedBytes = &v
	return s
}

// SetFailedObjects sets the FailedObjects field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetFailedObjects(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.FailedObjects = &v
	return s
}

// SetNotExistBytes sets the NotExistBytes field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetNotExistBytes(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.NotExistBytes = &v
	return s
}

// SetNotExistObjectCount sets the NotExistObjectCount field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetNotExistObjectCount(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.NotExistObjectCount = &v
	return s
}

// SetRemainingBytes sets the RemainingBytes field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetRemainingBytes(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.RemainingBytes = &v
	return s
}

// SetRemainingObjects sets the RemainingObjects field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetRemainingObjects(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.RemainingObjects = &v
	return s
}

// SetSkipBytes sets the SkipBytes field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetSkipBytes(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.SkipBytes = &v
	return s
}

// SetSkipObjectCount sets the SkipObjectCount field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetSkipObjectCount(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.SkipObjectCount = &v
	return s
}

// SetTotalBytes sets the TotalBytes field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetTotalBytes(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.TotalBytes = &v
	return s
}

// SetTotalObjects sets the TotalObjects field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetTotalObjects(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.TotalObjects = &v
	return s
}

// SetTransferBytesSpeed sets the TransferBytesSpeed field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetTransferBytesSpeed(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.TransferBytesSpeed = &v
	return s
}

// SetTransferCountSpeed sets the TransferCountSpeed field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetTransferCountSpeed(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.TransferCountSpeed = &v
	return s
}

// SetTransferredBytes sets the TransferredBytes field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetTransferredBytes(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.TransferredBytes = &v
	return s
}

// SetTransferredObjects sets the TransferredObjects field's value.
func (s *TaskProgressForListDataMigrateTaskOutput) SetTransferredObjects(v int64) *TaskProgressForListDataMigrateTaskOutput {
	s.TransferredObjects = &v
	return s
}

const (
	// EnumOfTaskStatusForListDataMigrateTaskInputPreparing is a EnumOfTaskStatusForListDataMigrateTaskInput enum value
	EnumOfTaskStatusForListDataMigrateTaskInputPreparing = "Preparing"

	// EnumOfTaskStatusForListDataMigrateTaskInputTransferring is a EnumOfTaskStatusForListDataMigrateTaskInput enum value
	EnumOfTaskStatusForListDataMigrateTaskInputTransferring = "Transferring"

	// EnumOfTaskStatusForListDataMigrateTaskInputSuspended is a EnumOfTaskStatusForListDataMigrateTaskInput enum value
	EnumOfTaskStatusForListDataMigrateTaskInputSuspended = "Suspended"

	// EnumOfTaskStatusForListDataMigrateTaskInputSuccess is a EnumOfTaskStatusForListDataMigrateTaskInput enum value
	EnumOfTaskStatusForListDataMigrateTaskInputSuccess = "Success"

	// EnumOfTaskStatusForListDataMigrateTaskInputStopping is a EnumOfTaskStatusForListDataMigrateTaskInput enum value
	EnumOfTaskStatusForListDataMigrateTaskInputStopping = "Stopping"

	// EnumOfTaskStatusForListDataMigrateTaskInputStopped is a EnumOfTaskStatusForListDataMigrateTaskInput enum value
	EnumOfTaskStatusForListDataMigrateTaskInputStopped = "Stopped"

	// EnumOfTaskStatusForListDataMigrateTaskInputFailure is a EnumOfTaskStatusForListDataMigrateTaskInput enum value
	EnumOfTaskStatusForListDataMigrateTaskInputFailure = "Failure"

	// EnumOfTaskStatusForListDataMigrateTaskInputResultGenerating is a EnumOfTaskStatusForListDataMigrateTaskInput enum value
	EnumOfTaskStatusForListDataMigrateTaskInputResultGenerating = "ResultGenerating"
)

const (
	// EnumOfTaskStatusForListDataMigrateTaskOutputPreparing is a EnumOfTaskStatusForListDataMigrateTaskOutput enum value
	EnumOfTaskStatusForListDataMigrateTaskOutputPreparing = "Preparing"

	// EnumOfTaskStatusForListDataMigrateTaskOutputTransferring is a EnumOfTaskStatusForListDataMigrateTaskOutput enum value
	EnumOfTaskStatusForListDataMigrateTaskOutputTransferring = "Transferring"

	// EnumOfTaskStatusForListDataMigrateTaskOutputSuspended is a EnumOfTaskStatusForListDataMigrateTaskOutput enum value
	EnumOfTaskStatusForListDataMigrateTaskOutputSuspended = "Suspended"

	// EnumOfTaskStatusForListDataMigrateTaskOutputSuccess is a EnumOfTaskStatusForListDataMigrateTaskOutput enum value
	EnumOfTaskStatusForListDataMigrateTaskOutputSuccess = "Success"

	// EnumOfTaskStatusForListDataMigrateTaskOutputStopping is a EnumOfTaskStatusForListDataMigrateTaskOutput enum value
	EnumOfTaskStatusForListDataMigrateTaskOutputStopping = "Stopping"

	// EnumOfTaskStatusForListDataMigrateTaskOutputStopped is a EnumOfTaskStatusForListDataMigrateTaskOutput enum value
	EnumOfTaskStatusForListDataMigrateTaskOutputStopped = "Stopped"

	// EnumOfTaskStatusForListDataMigrateTaskOutputFailure is a EnumOfTaskStatusForListDataMigrateTaskOutput enum value
	EnumOfTaskStatusForListDataMigrateTaskOutputFailure = "Failure"

	// EnumOfTaskStatusForListDataMigrateTaskOutputResultGenerating is a EnumOfTaskStatusForListDataMigrateTaskOutput enum value
	EnumOfTaskStatusForListDataMigrateTaskOutputResultGenerating = "ResultGenerating"
)
