// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dbw

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeSlowLogsCommon = "DescribeSlowLogs"

// DescribeSlowLogsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSlowLogsCommon operation. The "output" return
// value will be populated with the DescribeSlowLogsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSlowLogsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSlowLogsCommon Send returns without error.
//
// See DescribeSlowLogsCommon for more information on using the DescribeSlowLogsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeSlowLogsCommonRequest method.
//    req, resp := client.DescribeSlowLogsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DBW) DescribeSlowLogsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeSlowLogsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeSlowLogsCommon API operation for DBW.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DBW's
// API operation DescribeSlowLogsCommon for usage and error information.
func (c *DBW) DescribeSlowLogsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeSlowLogsCommonRequest(input)
	return out, req.Send()
}

// DescribeSlowLogsCommonWithContext is the same as DescribeSlowLogsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlowLogsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DBW) DescribeSlowLogsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeSlowLogsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSlowLogs = "DescribeSlowLogs"

// DescribeSlowLogsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSlowLogs operation. The "output" return
// value will be populated with the DescribeSlowLogsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSlowLogsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSlowLogsCommon Send returns without error.
//
// See DescribeSlowLogs for more information on using the DescribeSlowLogs
// API call, and error handling.
//
//    // Example sending a request using the DescribeSlowLogsRequest method.
//    req, resp := client.DescribeSlowLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DBW) DescribeSlowLogsRequest(input *DescribeSlowLogsInput) (req *request.Request, output *DescribeSlowLogsOutput) {
	op := &request.Operation{
		Name:       opDescribeSlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSlowLogsInput{}
	}

	output = &DescribeSlowLogsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeSlowLogs API operation for DBW.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DBW's
// API operation DescribeSlowLogs for usage and error information.
func (c *DBW) DescribeSlowLogs(input *DescribeSlowLogsInput) (*DescribeSlowLogsOutput, error) {
	req, out := c.DescribeSlowLogsRequest(input)
	return out, req.Send()
}

// DescribeSlowLogsWithContext is the same as DescribeSlowLogs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlowLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DBW) DescribeSlowLogsWithContext(ctx volcengine.Context, input *DescribeSlowLogsInput, opts ...request.Option) (*DescribeSlowLogsOutput, error) {
	req, out := c.DescribeSlowLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeSlowLogsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// EndTime is a required field
	EndTime *int32 `type:"int32" json:",omitempty" required:"true"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	InstanceType *string `type:"string" json:",omitempty" enum:"EnumOfInstanceTypeForDescribeSlowLogsInput"`

	NodeId *string `type:"string" json:",omitempty"`

	OrderBy *string `type:"string" json:",omitempty" enum:"EnumOfOrderByForDescribeSlowLogsInput"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	// RegionId is a required field
	RegionId *string `type:"string" json:",omitempty" required:"true"`

	SearchParam *SearchParamForDescribeSlowLogsInput `type:"structure" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForDescribeSlowLogsInput"`

	// StartTime is a required field
	StartTime *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeSlowLogsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSlowLogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSlowLogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSlowLogsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.RegionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionId"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeSlowLogsInput) SetEndTime(v int32) *DescribeSlowLogsInput {
	s.EndTime = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeSlowLogsInput) SetInstanceId(v string) *DescribeSlowLogsInput {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeSlowLogsInput) SetInstanceType(v string) *DescribeSlowLogsInput {
	s.InstanceType = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *DescribeSlowLogsInput) SetNodeId(v string) *DescribeSlowLogsInput {
	s.NodeId = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *DescribeSlowLogsInput) SetOrderBy(v string) *DescribeSlowLogsInput {
	s.OrderBy = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeSlowLogsInput) SetPageNumber(v int32) *DescribeSlowLogsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeSlowLogsInput) SetPageSize(v int32) *DescribeSlowLogsInput {
	s.PageSize = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *DescribeSlowLogsInput) SetRegionId(v string) *DescribeSlowLogsInput {
	s.RegionId = &v
	return s
}

// SetSearchParam sets the SearchParam field's value.
func (s *DescribeSlowLogsInput) SetSearchParam(v *SearchParamForDescribeSlowLogsInput) *DescribeSlowLogsInput {
	s.SearchParam = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *DescribeSlowLogsInput) SetSortBy(v string) *DescribeSlowLogsInput {
	s.SortBy = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeSlowLogsInput) SetStartTime(v int32) *DescribeSlowLogsInput {
	s.StartTime = &v
	return s
}

type DescribeSlowLogsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	SlowLogs []*SlowLogForDescribeSlowLogsOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeSlowLogsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSlowLogsOutput) GoString() string {
	return s.String()
}

// SetSlowLogs sets the SlowLogs field's value.
func (s *DescribeSlowLogsOutput) SetSlowLogs(v []*SlowLogForDescribeSlowLogsOutput) *DescribeSlowLogsOutput {
	s.SlowLogs = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeSlowLogsOutput) SetTotal(v int32) *DescribeSlowLogsOutput {
	s.Total = &v
	return s
}

type SearchParamForDescribeSlowLogsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DBs []*string `type:"list" json:",omitempty"`

	MaxQueryTime *float64 `type:"double" json:",omitempty"`

	MinQueryTime *float64 `type:"double" json:",omitempty"`

	SQLTemplate *string `type:"string" json:",omitempty"`

	SQLTemplateID *string `type:"string" json:",omitempty"`

	SourceIPs []*string `type:"list" json:",omitempty"`

	Users []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SearchParamForDescribeSlowLogsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchParamForDescribeSlowLogsInput) GoString() string {
	return s.String()
}

// SetDBs sets the DBs field's value.
func (s *SearchParamForDescribeSlowLogsInput) SetDBs(v []*string) *SearchParamForDescribeSlowLogsInput {
	s.DBs = v
	return s
}

// SetMaxQueryTime sets the MaxQueryTime field's value.
func (s *SearchParamForDescribeSlowLogsInput) SetMaxQueryTime(v float64) *SearchParamForDescribeSlowLogsInput {
	s.MaxQueryTime = &v
	return s
}

// SetMinQueryTime sets the MinQueryTime field's value.
func (s *SearchParamForDescribeSlowLogsInput) SetMinQueryTime(v float64) *SearchParamForDescribeSlowLogsInput {
	s.MinQueryTime = &v
	return s
}

// SetSQLTemplate sets the SQLTemplate field's value.
func (s *SearchParamForDescribeSlowLogsInput) SetSQLTemplate(v string) *SearchParamForDescribeSlowLogsInput {
	s.SQLTemplate = &v
	return s
}

// SetSQLTemplateID sets the SQLTemplateID field's value.
func (s *SearchParamForDescribeSlowLogsInput) SetSQLTemplateID(v string) *SearchParamForDescribeSlowLogsInput {
	s.SQLTemplateID = &v
	return s
}

// SetSourceIPs sets the SourceIPs field's value.
func (s *SearchParamForDescribeSlowLogsInput) SetSourceIPs(v []*string) *SearchParamForDescribeSlowLogsInput {
	s.SourceIPs = v
	return s
}

// SetUsers sets the Users field's value.
func (s *SearchParamForDescribeSlowLogsInput) SetUsers(v []*string) *SearchParamForDescribeSlowLogsInput {
	s.Users = v
	return s
}

type SlowLogForDescribeSlowLogsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConnectionId *int32 `type:"int32" json:",omitempty"`

	DB *string `type:"string" json:",omitempty"`

	LockTime *float64 `type:"double" json:",omitempty"`

	QueryTime *float64 `type:"double" json:",omitempty"`

	RowsExamined *int32 `type:"int32" json:",omitempty"`

	RowsSent *int32 `type:"int32" json:",omitempty"`

	SQLTemplate *string `type:"string" json:",omitempty"`

	SQLText *string `type:"string" json:",omitempty"`

	SourceIP *string `type:"string" json:",omitempty"`

	SqlFingerprint *string `type:"string" json:",omitempty"`

	SqlMethod *string `type:"string" json:",omitempty"`

	Table *string `type:"string" json:",omitempty"`

	Timestamp *int32 `type:"int32" json:",omitempty"`

	User *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SlowLogForDescribeSlowLogsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SlowLogForDescribeSlowLogsOutput) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetConnectionId(v int32) *SlowLogForDescribeSlowLogsOutput {
	s.ConnectionId = &v
	return s
}

// SetDB sets the DB field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetDB(v string) *SlowLogForDescribeSlowLogsOutput {
	s.DB = &v
	return s
}

// SetLockTime sets the LockTime field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetLockTime(v float64) *SlowLogForDescribeSlowLogsOutput {
	s.LockTime = &v
	return s
}

// SetQueryTime sets the QueryTime field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetQueryTime(v float64) *SlowLogForDescribeSlowLogsOutput {
	s.QueryTime = &v
	return s
}

// SetRowsExamined sets the RowsExamined field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetRowsExamined(v int32) *SlowLogForDescribeSlowLogsOutput {
	s.RowsExamined = &v
	return s
}

// SetRowsSent sets the RowsSent field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetRowsSent(v int32) *SlowLogForDescribeSlowLogsOutput {
	s.RowsSent = &v
	return s
}

// SetSQLTemplate sets the SQLTemplate field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetSQLTemplate(v string) *SlowLogForDescribeSlowLogsOutput {
	s.SQLTemplate = &v
	return s
}

// SetSQLText sets the SQLText field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetSQLText(v string) *SlowLogForDescribeSlowLogsOutput {
	s.SQLText = &v
	return s
}

// SetSourceIP sets the SourceIP field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetSourceIP(v string) *SlowLogForDescribeSlowLogsOutput {
	s.SourceIP = &v
	return s
}

// SetSqlFingerprint sets the SqlFingerprint field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetSqlFingerprint(v string) *SlowLogForDescribeSlowLogsOutput {
	s.SqlFingerprint = &v
	return s
}

// SetSqlMethod sets the SqlMethod field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetSqlMethod(v string) *SlowLogForDescribeSlowLogsOutput {
	s.SqlMethod = &v
	return s
}

// SetTable sets the Table field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetTable(v string) *SlowLogForDescribeSlowLogsOutput {
	s.Table = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetTimestamp(v int32) *SlowLogForDescribeSlowLogsOutput {
	s.Timestamp = &v
	return s
}

// SetUser sets the User field's value.
func (s *SlowLogForDescribeSlowLogsOutput) SetUser(v string) *SlowLogForDescribeSlowLogsOutput {
	s.User = &v
	return s
}

const (
	// EnumOfInstanceTypeForDescribeSlowLogsInputMySql is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputMySql = "MySQL"

	// EnumOfInstanceTypeForDescribeSlowLogsInputPostgres is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputPostgres = "Postgres"

	// EnumOfInstanceTypeForDescribeSlowLogsInputMongo is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputMongo = "Mongo"

	// EnumOfInstanceTypeForDescribeSlowLogsInputRedis is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputRedis = "Redis"

	// EnumOfInstanceTypeForDescribeSlowLogsInputVeDbmySql is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputVeDbmySql = "VeDBMySQL"

	// EnumOfInstanceTypeForDescribeSlowLogsInputMetaRds is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputMetaRds = "MetaRDS"

	// EnumOfInstanceTypeForDescribeSlowLogsInputMssql is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputMssql = "MSSQL"

	// EnumOfInstanceTypeForDescribeSlowLogsInputByteRds is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputByteRds = "ByteRDS"

	// EnumOfInstanceTypeForDescribeSlowLogsInputMySqlsharding is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputMySqlsharding = "MySQLSharding"

	// EnumOfInstanceTypeForDescribeSlowLogsInputMetaMySql is a EnumOfInstanceTypeForDescribeSlowLogsInput enum value
	EnumOfInstanceTypeForDescribeSlowLogsInputMetaMySql = "MetaMySQL"
)

const (
	// EnumOfOrderByForDescribeSlowLogsInputTimestamp is a EnumOfOrderByForDescribeSlowLogsInput enum value
	EnumOfOrderByForDescribeSlowLogsInputTimestamp = "Timestamp"

	// EnumOfOrderByForDescribeSlowLogsInputQueryTime is a EnumOfOrderByForDescribeSlowLogsInput enum value
	EnumOfOrderByForDescribeSlowLogsInputQueryTime = "QueryTime"

	// EnumOfOrderByForDescribeSlowLogsInputLockTime is a EnumOfOrderByForDescribeSlowLogsInput enum value
	EnumOfOrderByForDescribeSlowLogsInputLockTime = "LockTime"

	// EnumOfOrderByForDescribeSlowLogsInputRowsExamined is a EnumOfOrderByForDescribeSlowLogsInput enum value
	EnumOfOrderByForDescribeSlowLogsInputRowsExamined = "RowsExamined"

	// EnumOfOrderByForDescribeSlowLogsInputRowsSent is a EnumOfOrderByForDescribeSlowLogsInput enum value
	EnumOfOrderByForDescribeSlowLogsInputRowsSent = "RowsSent"
)

const (
	// EnumOfSortByForDescribeSlowLogsInputAsc is a EnumOfSortByForDescribeSlowLogsInput enum value
	EnumOfSortByForDescribeSlowLogsInputAsc = "ASC"

	// EnumOfSortByForDescribeSlowLogsInputDesc is a EnumOfSortByForDescribeSlowLogsInput enum value
	EnumOfSortByForDescribeSlowLogsInputDesc = "DESC"
)
