// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListUsersCommon = "ListUsers"

// ListUsersCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListUsersCommon operation. The "output" return
// value will be populated with the ListUsersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListUsersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListUsersCommon Send returns without error.
//
// See ListUsersCommon for more information on using the ListUsersCommon
// API call, and error handling.
//
//    // Example sending a request using the ListUsersCommonRequest method.
//    req, resp := client.ListUsersCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListUsersCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListUsersCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListUsersCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListUsersCommon for usage and error information.
func (c *CLOUDIDENTITY) ListUsersCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListUsersCommonRequest(input)
	return out, req.Send()
}

// ListUsersCommonWithContext is the same as ListUsersCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsersCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListUsersCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListUsersCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "volcengine/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the ListUsersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListUsersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListUsersCommon Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListUsers API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListUsers for usage and error information.
func (c *CLOUDIDENTITY) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListUsersWithContext(ctx volcengine.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListUsersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	QueryString *string `type:"string" json:",omitempty"`

	Source *string `type:"string" json:",omitempty" enum:"EnumOfSourceForListUsersInput"`

	UserName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListUsersInput) SetPageNumber(v int32) *ListUsersInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListUsersInput) SetPageSize(v int32) *ListUsersInput {
	s.PageSize = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *ListUsersInput) SetQueryString(v string) *ListUsersInput {
	s.QueryString = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ListUsersInput) SetSource(v string) *ListUsersInput {
	s.Source = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListUsersInput) SetUserName(v string) *ListUsersInput {
	s.UserName = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`

	Users []*UserForListUsersOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListUsersOutput) SetPageNumber(v int32) *ListUsersOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListUsersOutput) SetPageSize(v int32) *ListUsersOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListUsersOutput) SetTotal(v int64) *ListUsersOutput {
	s.Total = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*UserForListUsersOutput) *ListUsersOutput {
	s.Users = v
	return s
}

type UserForListUsersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreatedTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Email *string `type:"string" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`

	Source *string `type:"string" json:",omitempty" enum:"EnumOfSourceForListUsersOutput"`

	UpdatedTime *string `type:"string" json:",omitempty"`

	UserId *string `type:"string" json:",omitempty"`

	UserName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UserForListUsersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UserForListUsersOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *UserForListUsersOutput) SetCreatedTime(v string) *UserForListUsersOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UserForListUsersOutput) SetDescription(v string) *UserForListUsersOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UserForListUsersOutput) SetDisplayName(v string) *UserForListUsersOutput {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UserForListUsersOutput) SetEmail(v string) *UserForListUsersOutput {
	s.Email = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *UserForListUsersOutput) SetPhone(v string) *UserForListUsersOutput {
	s.Phone = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UserForListUsersOutput) SetSource(v string) *UserForListUsersOutput {
	s.Source = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *UserForListUsersOutput) SetUpdatedTime(v string) *UserForListUsersOutput {
	s.UpdatedTime = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UserForListUsersOutput) SetUserId(v string) *UserForListUsersOutput {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UserForListUsersOutput) SetUserName(v string) *UserForListUsersOutput {
	s.UserName = &v
	return s
}

const (
	// EnumOfSourceForListUsersInputSync is a EnumOfSourceForListUsersInput enum value
	EnumOfSourceForListUsersInputSync = "Sync"

	// EnumOfSourceForListUsersInputManual is a EnumOfSourceForListUsersInput enum value
	EnumOfSourceForListUsersInputManual = "Manual"
)

const (
	// EnumOfSourceForListUsersOutputSync is a EnumOfSourceForListUsersOutput enum value
	EnumOfSourceForListUsersOutputSync = "Sync"
)
