// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddetect

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetTaskCommon = "GetTask"

// GetTaskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetTaskCommon operation. The "output" return
// value will be populated with the GetTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetTaskCommon Send returns without error.
//
// See GetTaskCommon for more information on using the GetTaskCommon
// API call, and error handling.
//
//    // Example sending a request using the GetTaskCommonRequest method.
//    req, resp := client.GetTaskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) GetTaskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetTaskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetTaskCommon API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation GetTaskCommon for usage and error information.
func (c *CLOUDDETECT) GetTaskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetTaskCommonRequest(input)
	return out, req.Send()
}

// GetTaskCommonWithContext is the same as GetTaskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetTaskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) GetTaskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetTaskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTask = "GetTask"

// GetTaskRequest generates a "volcengine/request.Request" representing the
// client's request for the GetTask operation. The "output" return
// value will be populated with the GetTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetTaskCommon Send returns without error.
//
// See GetTask for more information on using the GetTask
// API call, and error handling.
//
//    // Example sending a request using the GetTaskRequest method.
//    req, resp := client.GetTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) GetTaskRequest(input *GetTaskInput) (req *request.Request, output *GetTaskOutput) {
	op := &request.Operation{
		Name:       opGetTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTaskInput{}
	}

	output = &GetTaskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetTask API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation GetTask for usage and error information.
func (c *CLOUDDETECT) GetTask(input *GetTaskInput) (*GetTaskOutput, error) {
	req, out := c.GetTaskRequest(input)
	return out, req.Send()
}

// GetTaskWithContext is the same as GetTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) GetTaskWithContext(ctx volcengine.Context, input *GetTaskInput, opts ...request.Option) (*GetTaskOutput, error) {
	req, out := c.GetTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type EndTimeForGetTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Hour *int32 `type:"int32" json:",omitempty"`

	Minute *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s EndTimeForGetTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EndTimeForGetTaskOutput) GoString() string {
	return s.String()
}

// SetHour sets the Hour field's value.
func (s *EndTimeForGetTaskOutput) SetHour(v int32) *EndTimeForGetTaskOutput {
	s.Hour = &v
	return s
}

// SetMinute sets the Minute field's value.
func (s *EndTimeForGetTaskOutput) SetMinute(v int32) *EndTimeForGetTaskOutput {
	s.Minute = &v
	return s
}

type GetTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// ID is a required field
	ID *int64 `type:"int64" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GetTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTaskInput"}
	if s.ID == nil {
		invalidParams.Add(request.NewErrParamRequired("ID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetID sets the ID field's value.
func (s *GetTaskInput) SetID(v int64) *GetTaskInput {
	s.ID = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *GetTaskInput) SetProjectName(v string) *GetTaskInput {
	s.ProjectName = &v
	return s
}

type GetTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Task *TaskForGetTaskOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s GetTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTaskOutput) GoString() string {
	return s.String()
}

// SetTask sets the Task field's value.
func (s *GetTaskOutput) SetTask(v *TaskForGetTaskOutput) *GetTaskOutput {
	s.Task = v
	return s
}

type LabelForGetTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	KeyID *int64 `type:"int64" json:",omitempty"`

	Option *string `type:"string" json:",omitempty"`

	OptionID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s LabelForGetTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelForGetTaskOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *LabelForGetTaskOutput) SetKey(v string) *LabelForGetTaskOutput {
	s.Key = &v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *LabelForGetTaskOutput) SetKeyID(v int64) *LabelForGetTaskOutput {
	s.KeyID = &v
	return s
}

// SetOption sets the Option field's value.
func (s *LabelForGetTaskOutput) SetOption(v string) *LabelForGetTaskOutput {
	s.Option = &v
	return s
}

// SetOptionID sets the OptionID field's value.
func (s *LabelForGetTaskOutput) SetOptionID(v int64) *LabelForGetTaskOutput {
	s.OptionID = &v
	return s
}

type PeriodConfigForGetTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Days []*int64 `type:"list" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	TimeRangeConfig []*TimeRangeConfigForGetTaskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s PeriodConfigForGetTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PeriodConfigForGetTaskOutput) GoString() string {
	return s.String()
}

// SetDays sets the Days field's value.
func (s *PeriodConfigForGetTaskOutput) SetDays(v []*int64) *PeriodConfigForGetTaskOutput {
	s.Days = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *PeriodConfigForGetTaskOutput) SetPeriod(v int32) *PeriodConfigForGetTaskOutput {
	s.Period = &v
	return s
}

// SetTimeRangeConfig sets the TimeRangeConfig field's value.
func (s *PeriodConfigForGetTaskOutput) SetTimeRangeConfig(v []*TimeRangeConfigForGetTaskOutput) *PeriodConfigForGetTaskOutput {
	s.TimeRangeConfig = v
	return s
}

type StartTimeForGetTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Hour *int32 `type:"int32" json:",omitempty"`

	Minute *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StartTimeForGetTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimeForGetTaskOutput) GoString() string {
	return s.String()
}

// SetHour sets the Hour field's value.
func (s *StartTimeForGetTaskOutput) SetHour(v int32) *StartTimeForGetTaskOutput {
	s.Hour = &v
	return s
}

// SetMinute sets the Minute field's value.
func (s *StartTimeForGetTaskOutput) SetMinute(v int32) *StartTimeForGetTaskOutput {
	s.Minute = &v
	return s
}

type TaskForGetTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	CreateTime *int64 `type:"int64" json:",omitempty"`

	EnableShuffle *bool `type:"boolean" json:",omitempty"`

	FinishTime *int64 `type:"int64" json:",omitempty"`

	HTTPMethod *int32 `type:"int32" json:",omitempty"`

	ID *int64 `type:"int64" json:",omitempty"`

	IntervalSeconds *int32 `type:"int32" json:",omitempty"`

	Labels []*LabelForGetTaskOutput `type:"list" json:",omitempty"`

	LineIDList []*int64 `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Owner *string `type:"string" json:",omitempty"`

	PeriodConfig *PeriodConfigForGetTaskOutput `type:"structure" json:",omitempty"`

	RunnerIDList []*int64 `type:"list" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SubTaskType *int32 `type:"int32" json:",omitempty"`

	TaskGroupID *int64 `type:"int64" json:",omitempty"`

	TaskGroupName *string `type:"string" json:",omitempty"`

	TaskType *int32 `type:"int32" json:",omitempty"`

	UpdateTime *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s TaskForGetTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskForGetTaskOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *TaskForGetTaskOutput) SetAddress(v string) *TaskForGetTaskOutput {
	s.Address = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *TaskForGetTaskOutput) SetCreateTime(v int64) *TaskForGetTaskOutput {
	s.CreateTime = &v
	return s
}

// SetEnableShuffle sets the EnableShuffle field's value.
func (s *TaskForGetTaskOutput) SetEnableShuffle(v bool) *TaskForGetTaskOutput {
	s.EnableShuffle = &v
	return s
}

// SetFinishTime sets the FinishTime field's value.
func (s *TaskForGetTaskOutput) SetFinishTime(v int64) *TaskForGetTaskOutput {
	s.FinishTime = &v
	return s
}

// SetHTTPMethod sets the HTTPMethod field's value.
func (s *TaskForGetTaskOutput) SetHTTPMethod(v int32) *TaskForGetTaskOutput {
	s.HTTPMethod = &v
	return s
}

// SetID sets the ID field's value.
func (s *TaskForGetTaskOutput) SetID(v int64) *TaskForGetTaskOutput {
	s.ID = &v
	return s
}

// SetIntervalSeconds sets the IntervalSeconds field's value.
func (s *TaskForGetTaskOutput) SetIntervalSeconds(v int32) *TaskForGetTaskOutput {
	s.IntervalSeconds = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *TaskForGetTaskOutput) SetLabels(v []*LabelForGetTaskOutput) *TaskForGetTaskOutput {
	s.Labels = v
	return s
}

// SetLineIDList sets the LineIDList field's value.
func (s *TaskForGetTaskOutput) SetLineIDList(v []*int64) *TaskForGetTaskOutput {
	s.LineIDList = v
	return s
}

// SetName sets the Name field's value.
func (s *TaskForGetTaskOutput) SetName(v string) *TaskForGetTaskOutput {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *TaskForGetTaskOutput) SetOwner(v string) *TaskForGetTaskOutput {
	s.Owner = &v
	return s
}

// SetPeriodConfig sets the PeriodConfig field's value.
func (s *TaskForGetTaskOutput) SetPeriodConfig(v *PeriodConfigForGetTaskOutput) *TaskForGetTaskOutput {
	s.PeriodConfig = v
	return s
}

// SetRunnerIDList sets the RunnerIDList field's value.
func (s *TaskForGetTaskOutput) SetRunnerIDList(v []*int64) *TaskForGetTaskOutput {
	s.RunnerIDList = v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaskForGetTaskOutput) SetStatus(v int32) *TaskForGetTaskOutput {
	s.Status = &v
	return s
}

// SetSubTaskType sets the SubTaskType field's value.
func (s *TaskForGetTaskOutput) SetSubTaskType(v int32) *TaskForGetTaskOutput {
	s.SubTaskType = &v
	return s
}

// SetTaskGroupID sets the TaskGroupID field's value.
func (s *TaskForGetTaskOutput) SetTaskGroupID(v int64) *TaskForGetTaskOutput {
	s.TaskGroupID = &v
	return s
}

// SetTaskGroupName sets the TaskGroupName field's value.
func (s *TaskForGetTaskOutput) SetTaskGroupName(v string) *TaskForGetTaskOutput {
	s.TaskGroupName = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *TaskForGetTaskOutput) SetTaskType(v int32) *TaskForGetTaskOutput {
	s.TaskType = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *TaskForGetTaskOutput) SetUpdateTime(v int64) *TaskForGetTaskOutput {
	s.UpdateTime = &v
	return s
}

type TimeRangeConfigForGetTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EndTime *EndTimeForGetTaskOutput `type:"structure" json:",omitempty"`

	Interval *int64 `type:"int64" json:",omitempty"`

	StartTime *StartTimeForGetTaskOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s TimeRangeConfigForGetTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRangeConfigForGetTaskOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRangeConfigForGetTaskOutput) SetEndTime(v *EndTimeForGetTaskOutput) *TimeRangeConfigForGetTaskOutput {
	s.EndTime = v
	return s
}

// SetInterval sets the Interval field's value.
func (s *TimeRangeConfigForGetTaskOutput) SetInterval(v int64) *TimeRangeConfigForGetTaskOutput {
	s.Interval = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRangeConfigForGetTaskOutput) SetStartTime(v *StartTimeForGetTaskOutput) *TimeRangeConfigForGetTaskOutput {
	s.StartTime = v
	return s
}
