// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeOriginSummaryCommon = "DescribeOriginSummary"

// DescribeOriginSummaryCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeOriginSummaryCommon operation. The "output" return
// value will be populated with the DescribeOriginSummaryCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeOriginSummaryCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeOriginSummaryCommon Send returns without error.
//
// See DescribeOriginSummaryCommon for more information on using the DescribeOriginSummaryCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeOriginSummaryCommonRequest method.
//    req, resp := client.DescribeOriginSummaryCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeOriginSummaryCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeOriginSummaryCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeOriginSummaryCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeOriginSummaryCommon for usage and error information.
func (c *CDN) DescribeOriginSummaryCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeOriginSummaryCommonRequest(input)
	return out, req.Send()
}

// DescribeOriginSummaryCommonWithContext is the same as DescribeOriginSummaryCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOriginSummaryCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeOriginSummaryCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeOriginSummaryCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOriginSummary = "DescribeOriginSummary"

// DescribeOriginSummaryRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeOriginSummary operation. The "output" return
// value will be populated with the DescribeOriginSummaryCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeOriginSummaryCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeOriginSummaryCommon Send returns without error.
//
// See DescribeOriginSummary for more information on using the DescribeOriginSummary
// API call, and error handling.
//
//    // Example sending a request using the DescribeOriginSummaryRequest method.
//    req, resp := client.DescribeOriginSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeOriginSummaryRequest(input *DescribeOriginSummaryInput) (req *request.Request, output *DescribeOriginSummaryOutput) {
	op := &request.Operation{
		Name:       opDescribeOriginSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOriginSummaryInput{}
	}

	output = &DescribeOriginSummaryOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeOriginSummary API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeOriginSummary for usage and error information.
func (c *CDN) DescribeOriginSummary(input *DescribeOriginSummaryInput) (*DescribeOriginSummaryOutput, error) {
	req, out := c.DescribeOriginSummaryRequest(input)
	return out, req.Send()
}

// DescribeOriginSummaryWithContext is the same as DescribeOriginSummary with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOriginSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeOriginSummaryWithContext(ctx volcengine.Context, input *DescribeOriginSummaryInput, opts ...request.Option) (*DescribeOriginSummaryOutput, error) {
	req, out := c.DescribeOriginSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeOriginSummaryInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	// EndTime is a required field
	EndTime *int64 `type:"int64" json:",omitempty" required:"true"`

	Interval *string `type:"string" json:",omitempty"`

	// Metric is a required field
	Metric *string `type:"string" json:",omitempty" required:"true"`

	Project *string `type:"string" json:",omitempty"`

	// StartTime is a required field
	StartTime *int64 `type:"int64" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeOriginSummaryInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOriginSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOriginSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOriginSummaryInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeOriginSummaryInput) SetDomain(v string) *DescribeOriginSummaryInput {
	s.Domain = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeOriginSummaryInput) SetEndTime(v int64) *DescribeOriginSummaryInput {
	s.EndTime = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *DescribeOriginSummaryInput) SetInterval(v string) *DescribeOriginSummaryInput {
	s.Interval = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *DescribeOriginSummaryInput) SetMetric(v string) *DescribeOriginSummaryInput {
	s.Metric = &v
	return s
}

// SetProject sets the Project field's value.
func (s *DescribeOriginSummaryInput) SetProject(v string) *DescribeOriginSummaryInput {
	s.Project = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeOriginSummaryInput) SetStartTime(v int64) *DescribeOriginSummaryInput {
	s.StartTime = &v
	return s
}

type DescribeOriginSummaryOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	MetricDataList []*MetricDataListForDescribeOriginSummaryOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeOriginSummaryOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOriginSummaryOutput) GoString() string {
	return s.String()
}

// SetMetricDataList sets the MetricDataList field's value.
func (s *DescribeOriginSummaryOutput) SetMetricDataList(v []*MetricDataListForDescribeOriginSummaryOutput) *DescribeOriginSummaryOutput {
	s.MetricDataList = v
	return s
}

type MetricDataListForDescribeOriginSummaryOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metric *string `type:"string" json:",omitempty"`

	Value *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s MetricDataListForDescribeOriginSummaryOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDataListForDescribeOriginSummaryOutput) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *MetricDataListForDescribeOriginSummaryOutput) SetMetric(v string) *MetricDataListForDescribeOriginSummaryOutput {
	s.Metric = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDataListForDescribeOriginSummaryOutput) SetValue(v float64) *MetricDataListForDescribeOriginSummaryOutput {
	s.Value = &v
	return s
}
