// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeOriginDataCommon = "DescribeOriginData"

// DescribeOriginDataCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeOriginDataCommon operation. The "output" return
// value will be populated with the DescribeOriginDataCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeOriginDataCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeOriginDataCommon Send returns without error.
//
// See DescribeOriginDataCommon for more information on using the DescribeOriginDataCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeOriginDataCommonRequest method.
//    req, resp := client.DescribeOriginDataCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeOriginDataCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeOriginDataCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeOriginDataCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeOriginDataCommon for usage and error information.
func (c *CDN) DescribeOriginDataCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeOriginDataCommonRequest(input)
	return out, req.Send()
}

// DescribeOriginDataCommonWithContext is the same as DescribeOriginDataCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOriginDataCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeOriginDataCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeOriginDataCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOriginData = "DescribeOriginData"

// DescribeOriginDataRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeOriginData operation. The "output" return
// value will be populated with the DescribeOriginDataCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeOriginDataCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeOriginDataCommon Send returns without error.
//
// See DescribeOriginData for more information on using the DescribeOriginData
// API call, and error handling.
//
//    // Example sending a request using the DescribeOriginDataRequest method.
//    req, resp := client.DescribeOriginDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeOriginDataRequest(input *DescribeOriginDataInput) (req *request.Request, output *DescribeOriginDataOutput) {
	op := &request.Operation{
		Name:       opDescribeOriginData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOriginDataInput{}
	}

	output = &DescribeOriginDataOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeOriginData API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeOriginData for usage and error information.
func (c *CDN) DescribeOriginData(input *DescribeOriginDataInput) (*DescribeOriginDataOutput, error) {
	req, out := c.DescribeOriginDataRequest(input)
	return out, req.Send()
}

// DescribeOriginDataWithContext is the same as DescribeOriginData with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOriginData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeOriginDataWithContext(ctx volcengine.Context, input *DescribeOriginDataInput, opts ...request.Option) (*DescribeOriginDataOutput, error) {
	req, out := c.DescribeOriginDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeOriginDataInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	// EndTime is a required field
	EndTime *int64 `type:"int64" json:",omitempty" required:"true"`

	Interval *string `type:"string" json:",omitempty"`

	// Metric is a required field
	Metric *string `type:"string" json:",omitempty" required:"true"`

	Project *string `type:"string" json:",omitempty"`

	// StartTime is a required field
	StartTime *int64 `type:"int64" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeOriginDataInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOriginDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOriginDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOriginDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeOriginDataInput) SetDomain(v string) *DescribeOriginDataInput {
	s.Domain = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeOriginDataInput) SetEndTime(v int64) *DescribeOriginDataInput {
	s.EndTime = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *DescribeOriginDataInput) SetInterval(v string) *DescribeOriginDataInput {
	s.Interval = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *DescribeOriginDataInput) SetMetric(v string) *DescribeOriginDataInput {
	s.Metric = &v
	return s
}

// SetProject sets the Project field's value.
func (s *DescribeOriginDataInput) SetProject(v string) *DescribeOriginDataInput {
	s.Project = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeOriginDataInput) SetStartTime(v int64) *DescribeOriginDataInput {
	s.StartTime = &v
	return s
}

type DescribeOriginDataOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	MetricDataList []*MetricDataListForDescribeOriginDataOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeOriginDataOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOriginDataOutput) GoString() string {
	return s.String()
}

// SetMetricDataList sets the MetricDataList field's value.
func (s *DescribeOriginDataOutput) SetMetricDataList(v []*MetricDataListForDescribeOriginDataOutput) *DescribeOriginDataOutput {
	s.MetricDataList = v
	return s
}

type MetricDataListForDescribeOriginDataOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metric *string `type:"string" json:",omitempty"`

	Values []*ValueForDescribeOriginDataOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s MetricDataListForDescribeOriginDataOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDataListForDescribeOriginDataOutput) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *MetricDataListForDescribeOriginDataOutput) SetMetric(v string) *MetricDataListForDescribeOriginDataOutput {
	s.Metric = &v
	return s
}

// SetValues sets the Values field's value.
func (s *MetricDataListForDescribeOriginDataOutput) SetValues(v []*ValueForDescribeOriginDataOutput) *MetricDataListForDescribeOriginDataOutput {
	s.Values = v
	return s
}

type ValueForDescribeOriginDataOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Item *string `type:"string" json:",omitempty"`

	TimeStamp *int64 `type:"int64" json:",omitempty"`

	Value *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s ValueForDescribeOriginDataOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ValueForDescribeOriginDataOutput) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ValueForDescribeOriginDataOutput) SetItem(v string) *ValueForDescribeOriginDataOutput {
	s.Item = &v
	return s
}

// SetTimeStamp sets the TimeStamp field's value.
func (s *ValueForDescribeOriginDataOutput) SetTimeStamp(v int64) *ValueForDescribeOriginDataOutput {
	s.TimeStamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ValueForDescribeOriginDataOutput) SetValue(v float64) *ValueForDescribeOriginDataOutput {
	s.Value = &v
	return s
}
