// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateSubmissionCommon = "CreateSubmission"

// CreateSubmissionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateSubmissionCommon operation. The "output" return
// value will be populated with the CreateSubmissionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateSubmissionCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateSubmissionCommon Send returns without error.
//
// See CreateSubmissionCommon for more information on using the CreateSubmissionCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateSubmissionCommonRequest method.
//    req, resp := client.CreateSubmissionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) CreateSubmissionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateSubmissionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateSubmissionCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation CreateSubmissionCommon for usage and error information.
func (c *BIO) CreateSubmissionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateSubmissionCommonRequest(input)
	return out, req.Send()
}

// CreateSubmissionCommonWithContext is the same as CreateSubmissionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubmissionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) CreateSubmissionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateSubmissionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubmission = "CreateSubmission"

// CreateSubmissionRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateSubmission operation. The "output" return
// value will be populated with the CreateSubmissionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateSubmissionCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateSubmissionCommon Send returns without error.
//
// See CreateSubmission for more information on using the CreateSubmission
// API call, and error handling.
//
//    // Example sending a request using the CreateSubmissionRequest method.
//    req, resp := client.CreateSubmissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) CreateSubmissionRequest(input *CreateSubmissionInput) (req *request.Request, output *CreateSubmissionOutput) {
	op := &request.Operation{
		Name:       opCreateSubmission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubmissionInput{}
	}

	output = &CreateSubmissionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateSubmission API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation CreateSubmission for usage and error information.
func (c *BIO) CreateSubmission(input *CreateSubmissionInput) (*CreateSubmissionOutput, error) {
	req, out := c.CreateSubmissionRequest(input)
	return out, req.Send()
}

// CreateSubmissionWithContext is the same as CreateSubmission with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubmission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) CreateSubmissionWithContext(ctx volcengine.Context, input *CreateSubmissionInput, opts ...request.Option) (*CreateSubmissionOutput, error) {
	req, out := c.CreateSubmissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateSubmissionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// ClusterID is a required field
	ClusterID *string `type:"string" json:",omitempty" required:"true"`

	DataModelID *string `type:"string" json:",omitempty"`

	DataModelRowIDs []*string `type:"list" json:",omitempty"`

	Description *string `max:"1000" type:"string" json:",omitempty"`

	ExposedOptions *ExposedOptionsForCreateSubmissionInput `type:"structure" json:",omitempty"`

	// Inputs is a required field
	Inputs *string `type:"string" json:",omitempty" required:"true"`

	// Name is a required field
	Name *string `min:"11" max:"409" type:"string" json:",omitempty" required:"true"`

	// Outputs is a required field
	Outputs *string `type:"string" json:",omitempty" required:"true"`

	// WorkflowID is a required field
	WorkflowID *string `type:"string" json:",omitempty" required:"true"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateSubmissionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubmissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubmissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubmissionInput"}
	if s.ClusterID == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterID"))
	}
	if s.Description != nil && len(*s.Description) > 1000 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 1000, *s.Description))
	}
	if s.Inputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Inputs"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 11))
	}
	if s.Name != nil && len(*s.Name) > 409 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 409, *s.Name))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.WorkflowID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowID"))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterID sets the ClusterID field's value.
func (s *CreateSubmissionInput) SetClusterID(v string) *CreateSubmissionInput {
	s.ClusterID = &v
	return s
}

// SetDataModelID sets the DataModelID field's value.
func (s *CreateSubmissionInput) SetDataModelID(v string) *CreateSubmissionInput {
	s.DataModelID = &v
	return s
}

// SetDataModelRowIDs sets the DataModelRowIDs field's value.
func (s *CreateSubmissionInput) SetDataModelRowIDs(v []*string) *CreateSubmissionInput {
	s.DataModelRowIDs = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSubmissionInput) SetDescription(v string) *CreateSubmissionInput {
	s.Description = &v
	return s
}

// SetExposedOptions sets the ExposedOptions field's value.
func (s *CreateSubmissionInput) SetExposedOptions(v *ExposedOptionsForCreateSubmissionInput) *CreateSubmissionInput {
	s.ExposedOptions = v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *CreateSubmissionInput) SetInputs(v string) *CreateSubmissionInput {
	s.Inputs = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSubmissionInput) SetName(v string) *CreateSubmissionInput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateSubmissionInput) SetOutputs(v string) *CreateSubmissionInput {
	s.Outputs = &v
	return s
}

// SetWorkflowID sets the WorkflowID field's value.
func (s *CreateSubmissionInput) SetWorkflowID(v string) *CreateSubmissionInput {
	s.WorkflowID = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *CreateSubmissionInput) SetWorkspaceID(v string) *CreateSubmissionInput {
	s.WorkspaceID = &v
	return s
}

type CreateSubmissionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateSubmissionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubmissionOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *CreateSubmissionOutput) SetID(v string) *CreateSubmissionOutput {
	s.ID = &v
	return s
}

type ExposedOptionsForCreateSubmissionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AAIPassport *string `type:"string" json:",omitempty"`

	ExecutionRootDir *string `type:"string" json:",omitempty"`

	MountTOS *bool `type:"boolean" json:",omitempty"`

	ReadFromCache *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ExposedOptionsForCreateSubmissionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExposedOptionsForCreateSubmissionInput) GoString() string {
	return s.String()
}

// SetAAIPassport sets the AAIPassport field's value.
func (s *ExposedOptionsForCreateSubmissionInput) SetAAIPassport(v string) *ExposedOptionsForCreateSubmissionInput {
	s.AAIPassport = &v
	return s
}

// SetExecutionRootDir sets the ExecutionRootDir field's value.
func (s *ExposedOptionsForCreateSubmissionInput) SetExecutionRootDir(v string) *ExposedOptionsForCreateSubmissionInput {
	s.ExecutionRootDir = &v
	return s
}

// SetMountTOS sets the MountTOS field's value.
func (s *ExposedOptionsForCreateSubmissionInput) SetMountTOS(v bool) *ExposedOptionsForCreateSubmissionInput {
	s.MountTOS = &v
	return s
}

// SetReadFromCache sets the ReadFromCache field's value.
func (s *ExposedOptionsForCreateSubmissionInput) SetReadFromCache(v bool) *ExposedOptionsForCreateSubmissionInput {
	s.ReadFromCache = &v
	return s
}
