// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package alb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyServerGroupAttributesCommon = "ModifyServerGroupAttributes"

// ModifyServerGroupAttributesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyServerGroupAttributesCommon operation. The "output" return
// value will be populated with the ModifyServerGroupAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyServerGroupAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyServerGroupAttributesCommon Send returns without error.
//
// See ModifyServerGroupAttributesCommon for more information on using the ModifyServerGroupAttributesCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyServerGroupAttributesCommonRequest method.
//    req, resp := client.ModifyServerGroupAttributesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) ModifyServerGroupAttributesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyServerGroupAttributesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyServerGroupAttributesCommon API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation ModifyServerGroupAttributesCommon for usage and error information.
func (c *ALB) ModifyServerGroupAttributesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyServerGroupAttributesCommonRequest(input)
	return out, req.Send()
}

// ModifyServerGroupAttributesCommonWithContext is the same as ModifyServerGroupAttributesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyServerGroupAttributesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) ModifyServerGroupAttributesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyServerGroupAttributesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyServerGroupAttributes = "ModifyServerGroupAttributes"

// ModifyServerGroupAttributesRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyServerGroupAttributes operation. The "output" return
// value will be populated with the ModifyServerGroupAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyServerGroupAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyServerGroupAttributesCommon Send returns without error.
//
// See ModifyServerGroupAttributes for more information on using the ModifyServerGroupAttributes
// API call, and error handling.
//
//    // Example sending a request using the ModifyServerGroupAttributesRequest method.
//    req, resp := client.ModifyServerGroupAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) ModifyServerGroupAttributesRequest(input *ModifyServerGroupAttributesInput) (req *request.Request, output *ModifyServerGroupAttributesOutput) {
	op := &request.Operation{
		Name:       opModifyServerGroupAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyServerGroupAttributesInput{}
	}

	output = &ModifyServerGroupAttributesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyServerGroupAttributes API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation ModifyServerGroupAttributes for usage and error information.
func (c *ALB) ModifyServerGroupAttributes(input *ModifyServerGroupAttributesInput) (*ModifyServerGroupAttributesOutput, error) {
	req, out := c.ModifyServerGroupAttributesRequest(input)
	return out, req.Send()
}

// ModifyServerGroupAttributesWithContext is the same as ModifyServerGroupAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyServerGroupAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) ModifyServerGroupAttributesWithContext(ctx volcengine.Context, input *ModifyServerGroupAttributesInput, opts ...request.Option) (*ModifyServerGroupAttributesOutput, error) {
	req, out := c.ModifyServerGroupAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type HealthCheckForModifyServerGroupAttributesInput struct {
	_ struct{} `type:"structure"`

	Domain *string `type:"string"`

	Enabled *string `type:"string"`

	HealthyThreshold *string `type:"string"`

	HttpCode *string `type:"string"`

	HttpVersion *string `type:"string"`

	Interval *string `type:"string"`

	Method *string `type:"string"`

	// Port is a required field
	Port *int64 `max:"65535" type:"integer" required:"true"`

	Protocol *string `type:"string"`

	Timeout *string `type:"string"`

	URI *string `type:"string"`

	UnhealthyThreshold *string `type:"string"`
}

// String returns the string representation
func (s HealthCheckForModifyServerGroupAttributesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckForModifyServerGroupAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckForModifyServerGroupAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckForModifyServerGroupAttributesInput"}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port > 65535 {
		invalidParams.Add(request.NewErrParamMaxValue("Port", 65535))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetDomain(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.Domain = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetEnabled(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.Enabled = &v
	return s
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetHealthyThreshold(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.HealthyThreshold = &v
	return s
}

// SetHttpCode sets the HttpCode field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetHttpCode(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.HttpCode = &v
	return s
}

// SetHttpVersion sets the HttpVersion field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetHttpVersion(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.HttpVersion = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetInterval(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.Interval = &v
	return s
}

// SetMethod sets the Method field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetMethod(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.Method = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetPort(v int64) *HealthCheckForModifyServerGroupAttributesInput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetProtocol(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.Protocol = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetTimeout(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.Timeout = &v
	return s
}

// SetURI sets the URI field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetURI(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.URI = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *HealthCheckForModifyServerGroupAttributesInput) SetUnhealthyThreshold(v string) *HealthCheckForModifyServerGroupAttributesInput {
	s.UnhealthyThreshold = &v
	return s
}

type ModifyServerGroupAttributesInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	HealthCheck *HealthCheckForModifyServerGroupAttributesInput `type:"structure"`

	Scheduler *string `type:"string"`

	// ServerGroupId is a required field
	ServerGroupId *string `type:"string" required:"true"`

	ServerGroupName *string `type:"string"`

	StickySessionConfig *StickySessionConfigForModifyServerGroupAttributesInput `type:"structure"`
}

// String returns the string representation
func (s ModifyServerGroupAttributesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyServerGroupAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyServerGroupAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyServerGroupAttributesInput"}
	if s.ServerGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerGroupId"))
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ModifyServerGroupAttributesInput) SetDescription(v string) *ModifyServerGroupAttributesInput {
	s.Description = &v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *ModifyServerGroupAttributesInput) SetHealthCheck(v *HealthCheckForModifyServerGroupAttributesInput) *ModifyServerGroupAttributesInput {
	s.HealthCheck = v
	return s
}

// SetScheduler sets the Scheduler field's value.
func (s *ModifyServerGroupAttributesInput) SetScheduler(v string) *ModifyServerGroupAttributesInput {
	s.Scheduler = &v
	return s
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *ModifyServerGroupAttributesInput) SetServerGroupId(v string) *ModifyServerGroupAttributesInput {
	s.ServerGroupId = &v
	return s
}

// SetServerGroupName sets the ServerGroupName field's value.
func (s *ModifyServerGroupAttributesInput) SetServerGroupName(v string) *ModifyServerGroupAttributesInput {
	s.ServerGroupName = &v
	return s
}

// SetStickySessionConfig sets the StickySessionConfig field's value.
func (s *ModifyServerGroupAttributesInput) SetStickySessionConfig(v *StickySessionConfigForModifyServerGroupAttributesInput) *ModifyServerGroupAttributesInput {
	s.StickySessionConfig = v
	return s
}

type ModifyServerGroupAttributesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ModifyServerGroupAttributesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyServerGroupAttributesOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ModifyServerGroupAttributesOutput) SetRequestId(v string) *ModifyServerGroupAttributesOutput {
	s.RequestId = &v
	return s
}

type StickySessionConfigForModifyServerGroupAttributesInput struct {
	_ struct{} `type:"structure"`

	Cookie *string `type:"string"`

	CookieTimeout *string `type:"string"`

	StickySessionEnabled *string `type:"string"`

	StickySessionType *string `type:"string"`
}

// String returns the string representation
func (s StickySessionConfigForModifyServerGroupAttributesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StickySessionConfigForModifyServerGroupAttributesInput) GoString() string {
	return s.String()
}

// SetCookie sets the Cookie field's value.
func (s *StickySessionConfigForModifyServerGroupAttributesInput) SetCookie(v string) *StickySessionConfigForModifyServerGroupAttributesInput {
	s.Cookie = &v
	return s
}

// SetCookieTimeout sets the CookieTimeout field's value.
func (s *StickySessionConfigForModifyServerGroupAttributesInput) SetCookieTimeout(v string) *StickySessionConfigForModifyServerGroupAttributesInput {
	s.CookieTimeout = &v
	return s
}

// SetStickySessionEnabled sets the StickySessionEnabled field's value.
func (s *StickySessionConfigForModifyServerGroupAttributesInput) SetStickySessionEnabled(v string) *StickySessionConfigForModifyServerGroupAttributesInput {
	s.StickySessionEnabled = &v
	return s
}

// SetStickySessionType sets the StickySessionType field's value.
func (s *StickySessionConfigForModifyServerGroupAttributesInput) SetStickySessionType(v string) *StickySessionConfigForModifyServerGroupAttributesInput {
	s.StickySessionType = &v
	return s
}
