// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package aiotvideo

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opStartStreamCommon = "StartStream"

// StartStreamCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the StartStreamCommon operation. The "output" return
// value will be populated with the StartStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StartStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after StartStreamCommon Send returns without error.
//
// See StartStreamCommon for more information on using the StartStreamCommon
// API call, and error handling.
//
//    // Example sending a request using the StartStreamCommonRequest method.
//    req, resp := client.StartStreamCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO) StartStreamCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opStartStreamCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StartStreamCommon API operation for AIOTVIDEO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO's
// API operation StartStreamCommon for usage and error information.
func (c *AIOTVIDEO) StartStreamCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.StartStreamCommonRequest(input)
	return out, req.Send()
}

// StartStreamCommonWithContext is the same as StartStreamCommon with the addition of
// the ability to pass a context and additional request options.
//
// See StartStreamCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO) StartStreamCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.StartStreamCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartStream = "StartStream"

// StartStreamRequest generates a "volcengine/request.Request" representing the
// client's request for the StartStream operation. The "output" return
// value will be populated with the StartStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StartStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after StartStreamCommon Send returns without error.
//
// See StartStream for more information on using the StartStream
// API call, and error handling.
//
//    // Example sending a request using the StartStreamRequest method.
//    req, resp := client.StartStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO) StartStreamRequest(input *StartStreamInput) (req *request.Request, output *StartStreamOutput) {
	op := &request.Operation{
		Name:       opStartStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartStreamInput{}
	}

	output = &StartStreamOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StartStream API operation for AIOTVIDEO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO's
// API operation StartStream for usage and error information.
func (c *AIOTVIDEO) StartStream(input *StartStreamInput) (*StartStreamOutput, error) {
	req, out := c.StartStreamRequest(input)
	return out, req.Send()
}

// StartStreamWithContext is the same as StartStream with the addition of
// the ability to pass a context and additional request options.
//
// See StartStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO) StartStreamWithContext(ctx volcengine.Context, input *StartStreamInput, opts ...request.Option) (*StartStreamOutput, error) {
	req, out := c.StartStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type StartStreamInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableAudioTranscode *string `type:"string" json:",omitempty"`

	FreshExpiredPull *string `type:"string" json:",omitempty"`

	IgnoreAudio *string `type:"string" json:",omitempty"`

	Resolution *string `type:"string" json:",omitempty"`

	SpaceID *string `type:"string" json:",omitempty"`

	// StreamID is a required field
	StreamID *string `type:"string" json:",omitempty" required:"true"`

	StreamingIndex *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StartStreamInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartStreamInput"}
	if s.StreamID == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableAudioTranscode sets the EnableAudioTranscode field's value.
func (s *StartStreamInput) SetEnableAudioTranscode(v string) *StartStreamInput {
	s.EnableAudioTranscode = &v
	return s
}

// SetFreshExpiredPull sets the FreshExpiredPull field's value.
func (s *StartStreamInput) SetFreshExpiredPull(v string) *StartStreamInput {
	s.FreshExpiredPull = &v
	return s
}

// SetIgnoreAudio sets the IgnoreAudio field's value.
func (s *StartStreamInput) SetIgnoreAudio(v string) *StartStreamInput {
	s.IgnoreAudio = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *StartStreamInput) SetResolution(v string) *StartStreamInput {
	s.Resolution = &v
	return s
}

// SetSpaceID sets the SpaceID field's value.
func (s *StartStreamInput) SetSpaceID(v string) *StartStreamInput {
	s.SpaceID = &v
	return s
}

// SetStreamID sets the StreamID field's value.
func (s *StartStreamInput) SetStreamID(v string) *StartStreamInput {
	s.StreamID = &v
	return s
}

// SetStreamingIndex sets the StreamingIndex field's value.
func (s *StartStreamInput) SetStreamingIndex(v int32) *StartStreamInput {
	s.StreamingIndex = &v
	return s
}

type StartStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ID *string `type:"string" json:",omitempty"`

	PullUrls []*string `type:"list" json:",omitempty"`

	TransPullUrls []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StartStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartStreamOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *StartStreamOutput) SetID(v string) *StartStreamOutput {
	s.ID = &v
	return s
}

// SetPullUrls sets the PullUrls field's value.
func (s *StartStreamOutput) SetPullUrls(v []*string) *StartStreamOutput {
	s.PullUrls = v
	return s
}

// SetTransPullUrls sets the TransPullUrls field's value.
func (s *StartStreamOutput) SetTransPullUrls(v []*string) *StartStreamOutput {
	s.TransPullUrls = v
	return s
}
