// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package acep

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opStartScreenShotCommon = "StartScreenShot"

// StartScreenShotCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the StartScreenShotCommon operation. The "output" return
// value will be populated with the StartScreenShotCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StartScreenShotCommon Request to send the API call to the service.
// the "output" return value is not valid until after StartScreenShotCommon Send returns without error.
//
// See StartScreenShotCommon for more information on using the StartScreenShotCommon
// API call, and error handling.
//
//    // Example sending a request using the StartScreenShotCommonRequest method.
//    req, resp := client.StartScreenShotCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ACEP) StartScreenShotCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opStartScreenShotCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StartScreenShotCommon API operation for ACEP.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ACEP's
// API operation StartScreenShotCommon for usage and error information.
func (c *ACEP) StartScreenShotCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.StartScreenShotCommonRequest(input)
	return out, req.Send()
}

// StartScreenShotCommonWithContext is the same as StartScreenShotCommon with the addition of
// the ability to pass a context and additional request options.
//
// See StartScreenShotCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACEP) StartScreenShotCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.StartScreenShotCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartScreenShot = "StartScreenShot"

// StartScreenShotRequest generates a "volcengine/request.Request" representing the
// client's request for the StartScreenShot operation. The "output" return
// value will be populated with the StartScreenShotCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StartScreenShotCommon Request to send the API call to the service.
// the "output" return value is not valid until after StartScreenShotCommon Send returns without error.
//
// See StartScreenShot for more information on using the StartScreenShot
// API call, and error handling.
//
//    // Example sending a request using the StartScreenShotRequest method.
//    req, resp := client.StartScreenShotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ACEP) StartScreenShotRequest(input *StartScreenShotInput) (req *request.Request, output *StartScreenShotOutput) {
	op := &request.Operation{
		Name:       opStartScreenShot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartScreenShotInput{}
	}

	output = &StartScreenShotOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StartScreenShot API operation for ACEP.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ACEP's
// API operation StartScreenShot for usage and error information.
func (c *ACEP) StartScreenShot(input *StartScreenShotInput) (*StartScreenShotOutput, error) {
	req, out := c.StartScreenShotRequest(input)
	return out, req.Send()
}

// StartScreenShotWithContext is the same as StartScreenShot with the addition of
// the ability to pass a context and additional request options.
//
// See StartScreenShot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACEP) StartScreenShotWithContext(ctx volcengine.Context, input *StartScreenShotInput, opts ...request.Option) (*StartScreenShotOutput, error) {
	req, out := c.StartScreenShotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DetailForStartScreenShotOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DownloadUrl *string `type:"string" json:",omitempty"`

	ErrorCode *int32 `type:"int32" json:",omitempty"`

	ErrorMsg *string `type:"string" json:",omitempty"`

	ExpireAt *int64 `type:"int64" json:",omitempty"`

	Height *int32 `type:"int32" json:",omitempty"`

	PodId *string `type:"string" json:",omitempty"`

	Width *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DetailForStartScreenShotOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DetailForStartScreenShotOutput) GoString() string {
	return s.String()
}

// SetDownloadUrl sets the DownloadUrl field's value.
func (s *DetailForStartScreenShotOutput) SetDownloadUrl(v string) *DetailForStartScreenShotOutput {
	s.DownloadUrl = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *DetailForStartScreenShotOutput) SetErrorCode(v int32) *DetailForStartScreenShotOutput {
	s.ErrorCode = &v
	return s
}

// SetErrorMsg sets the ErrorMsg field's value.
func (s *DetailForStartScreenShotOutput) SetErrorMsg(v string) *DetailForStartScreenShotOutput {
	s.ErrorMsg = &v
	return s
}

// SetExpireAt sets the ExpireAt field's value.
func (s *DetailForStartScreenShotOutput) SetExpireAt(v int64) *DetailForStartScreenShotOutput {
	s.ExpireAt = &v
	return s
}

// SetHeight sets the Height field's value.
func (s *DetailForStartScreenShotOutput) SetHeight(v int32) *DetailForStartScreenShotOutput {
	s.Height = &v
	return s
}

// SetPodId sets the PodId field's value.
func (s *DetailForStartScreenShotOutput) SetPodId(v string) *DetailForStartScreenShotOutput {
	s.PodId = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *DetailForStartScreenShotOutput) SetWidth(v int32) *DetailForStartScreenShotOutput {
	s.Width = &v
	return s
}

type StartScreenShotInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationLimit *int32 `type:"int32" json:",omitempty"`

	FileType *string `type:"string" json:",omitempty"`

	Interval *int32 `type:"int32" json:",omitempty"`

	PodIdList []*string `type:"list" json:",omitempty"`

	// ProductId is a required field
	ProductId *string `type:"string" json:",omitempty" required:"true"`

	Quality *int32 `type:"int32" json:",omitempty"`

	Rotation *int32 `type:"int32" json:",omitempty"`

	Scale *float64 `type:"double" json:",omitempty"`

	TosInfo *TosInfoForStartScreenShotInput `type:"structure" json:",omitempty"`

	UploadType *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StartScreenShotInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartScreenShotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartScreenShotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartScreenShotInput"}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationLimit sets the DurationLimit field's value.
func (s *StartScreenShotInput) SetDurationLimit(v int32) *StartScreenShotInput {
	s.DurationLimit = &v
	return s
}

// SetFileType sets the FileType field's value.
func (s *StartScreenShotInput) SetFileType(v string) *StartScreenShotInput {
	s.FileType = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *StartScreenShotInput) SetInterval(v int32) *StartScreenShotInput {
	s.Interval = &v
	return s
}

// SetPodIdList sets the PodIdList field's value.
func (s *StartScreenShotInput) SetPodIdList(v []*string) *StartScreenShotInput {
	s.PodIdList = v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *StartScreenShotInput) SetProductId(v string) *StartScreenShotInput {
	s.ProductId = &v
	return s
}

// SetQuality sets the Quality field's value.
func (s *StartScreenShotInput) SetQuality(v int32) *StartScreenShotInput {
	s.Quality = &v
	return s
}

// SetRotation sets the Rotation field's value.
func (s *StartScreenShotInput) SetRotation(v int32) *StartScreenShotInput {
	s.Rotation = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *StartScreenShotInput) SetScale(v float64) *StartScreenShotInput {
	s.Scale = &v
	return s
}

// SetTosInfo sets the TosInfo field's value.
func (s *StartScreenShotInput) SetTosInfo(v *TosInfoForStartScreenShotInput) *StartScreenShotInput {
	s.TosInfo = v
	return s
}

// SetUploadType sets the UploadType field's value.
func (s *StartScreenShotInput) SetUploadType(v int32) *StartScreenShotInput {
	s.UploadType = &v
	return s
}

type StartScreenShotOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Details []*DetailForStartScreenShotOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StartScreenShotOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartScreenShotOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *StartScreenShotOutput) SetDetails(v []*DetailForStartScreenShotOutput) *StartScreenShotOutput {
	s.Details = v
	return s
}

type TosInfoForStartScreenShotInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bucket *string `type:"string" json:",omitempty"`

	Endpoint *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TosInfoForStartScreenShotInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosInfoForStartScreenShotInput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *TosInfoForStartScreenShotInput) SetBucket(v string) *TosInfoForStartScreenShotInput {
	s.Bucket = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *TosInfoForStartScreenShotInput) SetEndpoint(v string) *TosInfoForStartScreenShotInput {
	s.Endpoint = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *TosInfoForStartScreenShotInput) SetRegion(v string) *TosInfoForStartScreenShotInput {
	s.Region = &v
	return s
}
