// Example Code generated by Beijing Volcanoengine Technology.
package storageebsexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/storageebs"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DeleteTags() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := storageebs.New(sess)
	deleteTagsInput := &storageebs.DeleteTagsInput{
		ResourceIds:  volcengine.StringSlice([]string{"vol-76pwr6rilv8lzwxv*****", "vol-76pwr6rilv8lzwxv****"}),
		ResourceType: volcengine.String("volume"),
		TagKeys:      volcengine.StringSlice([]string{"tag"}),
	}

	resp, err := svc.DeleteTags(deleteTagsInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
