package wss

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceProperties invokes the wss.ModifyInstanceProperties API synchronously
func (client *Client) ModifyInstanceProperties(request *ModifyInstancePropertiesRequest) (response *ModifyInstancePropertiesResponse, err error) {
	response = CreateModifyInstancePropertiesResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstancePropertiesWithChan invokes the wss.ModifyInstanceProperties API asynchronously
func (client *Client) ModifyInstancePropertiesWithChan(request *ModifyInstancePropertiesRequest) (<-chan *ModifyInstancePropertiesResponse, <-chan error) {
	responseChan := make(chan *ModifyInstancePropertiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceProperties(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstancePropertiesWithCallback invokes the wss.ModifyInstanceProperties API asynchronously
func (client *Client) ModifyInstancePropertiesWithCallback(request *ModifyInstancePropertiesRequest, callback func(response *ModifyInstancePropertiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstancePropertiesResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceProperties(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstancePropertiesRequest is the request struct for api ModifyInstanceProperties
type ModifyInstancePropertiesRequest struct {
	*requests.RpcRequest
	ResourceType string    `position:"Query" name:"ResourceType"`
	InstanceId   string    `position:"Query" name:"InstanceId"`
	InstanceIds  *[]string `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Value        string    `position:"Query" name:"Value"`
	Key          string    `position:"Query" name:"Key"`
}

// ModifyInstancePropertiesResponse is the response struct for api ModifyInstanceProperties
type ModifyInstancePropertiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstancePropertiesRequest creates a request to invoke ModifyInstanceProperties API
func CreateModifyInstancePropertiesRequest() (request *ModifyInstancePropertiesRequest) {
	request = &ModifyInstancePropertiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("wss", "2021-12-21", "ModifyInstanceProperties", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyInstancePropertiesResponse creates a response to parse from ModifyInstanceProperties response
func CreateModifyInstancePropertiesResponse() (response *ModifyInstancePropertiesResponse) {
	response = &ModifyInstancePropertiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
