package vpcpeer

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpcPeerConnection invokes the vpcpeer.DeleteVpcPeerConnection API synchronously
func (client *Client) DeleteVpcPeerConnection(request *DeleteVpcPeerConnectionRequest) (response *DeleteVpcPeerConnectionResponse, err error) {
	response = CreateDeleteVpcPeerConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpcPeerConnectionWithChan invokes the vpcpeer.DeleteVpcPeerConnection API asynchronously
func (client *Client) DeleteVpcPeerConnectionWithChan(request *DeleteVpcPeerConnectionRequest) (<-chan *DeleteVpcPeerConnectionResponse, <-chan error) {
	responseChan := make(chan *DeleteVpcPeerConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpcPeerConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpcPeerConnectionWithCallback invokes the vpcpeer.DeleteVpcPeerConnection API asynchronously
func (client *Client) DeleteVpcPeerConnectionWithCallback(request *DeleteVpcPeerConnectionRequest, callback func(response *DeleteVpcPeerConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpcPeerConnectionResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpcPeerConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpcPeerConnectionRequest is the request struct for api DeleteVpcPeerConnection
type DeleteVpcPeerConnectionRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Body" name:"ClientToken"`
	Channel     string           `position:"Body" name:"Channel"`
	DryRun      requests.Boolean `position:"Body" name:"DryRun"`
	InstanceId  string           `position:"Body" name:"InstanceId"`
	Force       requests.Boolean `position:"Body" name:"Force"`
}

// DeleteVpcPeerConnectionResponse is the response struct for api DeleteVpcPeerConnection
type DeleteVpcPeerConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVpcPeerConnectionRequest creates a request to invoke DeleteVpcPeerConnection API
func CreateDeleteVpcPeerConnectionRequest() (request *DeleteVpcPeerConnectionRequest) {
	request = &DeleteVpcPeerConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VpcPeer", "2022-01-01", "DeleteVpcPeerConnection", "vpcpeer", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpcPeerConnectionResponse creates a response to parse from DeleteVpcPeerConnection response
func CreateDeleteVpcPeerConnectionResponse() (response *DeleteVpcPeerConnectionResponse) {
	response = &DeleteVpcPeerConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
