package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVSwitchCidrReservationAttribute invokes the vpc.ModifyVSwitchCidrReservationAttribute API synchronously
func (client *Client) ModifyVSwitchCidrReservationAttribute(request *ModifyVSwitchCidrReservationAttributeRequest) (response *ModifyVSwitchCidrReservationAttributeResponse, err error) {
	response = CreateModifyVSwitchCidrReservationAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVSwitchCidrReservationAttributeWithChan invokes the vpc.ModifyVSwitchCidrReservationAttribute API asynchronously
func (client *Client) ModifyVSwitchCidrReservationAttributeWithChan(request *ModifyVSwitchCidrReservationAttributeRequest) (<-chan *ModifyVSwitchCidrReservationAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyVSwitchCidrReservationAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVSwitchCidrReservationAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVSwitchCidrReservationAttributeWithCallback invokes the vpc.ModifyVSwitchCidrReservationAttribute API asynchronously
func (client *Client) ModifyVSwitchCidrReservationAttributeWithCallback(request *ModifyVSwitchCidrReservationAttributeRequest, callback func(response *ModifyVSwitchCidrReservationAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVSwitchCidrReservationAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyVSwitchCidrReservationAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVSwitchCidrReservationAttributeRequest is the request struct for api ModifyVSwitchCidrReservationAttribute
type ModifyVSwitchCidrReservationAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                       string           `position:"Query" name:"ClientToken"`
	VSwitchCidrReservationDescription string           `position:"Query" name:"VSwitchCidrReservationDescription"`
	VSwitchCidrReservationName        string           `position:"Query" name:"VSwitchCidrReservationName"`
	DryRun                            requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount              string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                      string           `position:"Query" name:"OwnerAccount"`
	OwnerId                           requests.Integer `position:"Query" name:"OwnerId"`
	VSwitchCidrReservationId          string           `position:"Query" name:"VSwitchCidrReservationId"`
}

// ModifyVSwitchCidrReservationAttributeResponse is the response struct for api ModifyVSwitchCidrReservationAttribute
type ModifyVSwitchCidrReservationAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVSwitchCidrReservationAttributeRequest creates a request to invoke ModifyVSwitchCidrReservationAttribute API
func CreateModifyVSwitchCidrReservationAttributeRequest() (request *ModifyVSwitchCidrReservationAttributeRequest) {
	request = &ModifyVSwitchCidrReservationAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyVSwitchCidrReservationAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyVSwitchCidrReservationAttributeResponse creates a response to parse from ModifyVSwitchCidrReservationAttribute response
func CreateModifyVSwitchCidrReservationAttributeResponse() (response *ModifyVSwitchCidrReservationAttributeResponse) {
	response = &ModifyVSwitchCidrReservationAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
