package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPublicIpAddressPools invokes the vpc.ListPublicIpAddressPools API synchronously
func (client *Client) ListPublicIpAddressPools(request *ListPublicIpAddressPoolsRequest) (response *ListPublicIpAddressPoolsResponse, err error) {
	response = CreateListPublicIpAddressPoolsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPublicIpAddressPoolsWithChan invokes the vpc.ListPublicIpAddressPools API asynchronously
func (client *Client) ListPublicIpAddressPoolsWithChan(request *ListPublicIpAddressPoolsRequest) (<-chan *ListPublicIpAddressPoolsResponse, <-chan error) {
	responseChan := make(chan *ListPublicIpAddressPoolsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPublicIpAddressPools(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPublicIpAddressPoolsWithCallback invokes the vpc.ListPublicIpAddressPools API asynchronously
func (client *Client) ListPublicIpAddressPoolsWithCallback(request *ListPublicIpAddressPoolsRequest, callback func(response *ListPublicIpAddressPoolsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPublicIpAddressPoolsResponse
		var err error
		defer close(result)
		response, err = client.ListPublicIpAddressPools(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPublicIpAddressPoolsRequest is the request struct for api ListPublicIpAddressPools
type ListPublicIpAddressPoolsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                       requests.Integer                `position:"Query" name:"ResourceOwnerId"`
	SecurityProtectionEnabled             requests.Boolean                `position:"Query" name:"SecurityProtectionEnabled"`
	Isp                                   string                          `position:"Query" name:"Isp"`
	SecurityProtectionEnabledForCommonBuy requests.Integer                `position:"Query" name:"SecurityProtectionEnabledForCommonBuy"`
	ResourceGroupId                       string                          `position:"Query" name:"ResourceGroupId"`
	NextToken                             string                          `position:"Query" name:"NextToken"`
	DryRun                                requests.Boolean                `position:"Query" name:"DryRun"`
	PublicIpAddressPoolIds                *[]string                       `position:"Query" name:"PublicIpAddressPoolIds"  type:"Repeated"`
	ResourceOwnerAccount                  string                          `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                          string                          `position:"Query" name:"OwnerAccount"`
	OwnerId                               requests.Integer                `position:"Query" name:"OwnerId"`
	Tags                                  *[]ListPublicIpAddressPoolsTags `position:"Query" name:"Tags"  type:"Repeated"`
	Name                                  string                          `position:"Query" name:"Name"`
	MaxResults                            requests.Integer                `position:"Query" name:"MaxResults"`
	Status                                string                          `position:"Query" name:"Status"`
}

// ListPublicIpAddressPoolsTags is a repeated param struct in ListPublicIpAddressPoolsRequest
type ListPublicIpAddressPoolsTags struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListPublicIpAddressPoolsResponse is the response struct for api ListPublicIpAddressPools
type ListPublicIpAddressPoolsResponse struct {
	*responses.BaseResponse
	RequestId               string                `json:"RequestId" xml:"RequestId"`
	NextToken               string                `json:"NextToken" xml:"NextToken"`
	MaxResults              int                   `json:"MaxResults" xml:"MaxResults"`
	TotalCount              int                   `json:"TotalCount" xml:"TotalCount"`
	PublicIpAddressPoolList []PublicIpAddressPool `json:"PublicIpAddressPoolList" xml:"PublicIpAddressPoolList"`
}

// CreateListPublicIpAddressPoolsRequest creates a request to invoke ListPublicIpAddressPools API
func CreateListPublicIpAddressPoolsRequest() (request *ListPublicIpAddressPoolsRequest) {
	request = &ListPublicIpAddressPoolsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListPublicIpAddressPools", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPublicIpAddressPoolsResponse creates a response to parse from ListPublicIpAddressPools response
func CreateListPublicIpAddressPoolsResponse() (response *ListPublicIpAddressPoolsResponse) {
	response = &ListPublicIpAddressPoolsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
