package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVSwitchCidrReservation invokes the vpc.CreateVSwitchCidrReservation API synchronously
func (client *Client) CreateVSwitchCidrReservation(request *CreateVSwitchCidrReservationRequest) (response *CreateVSwitchCidrReservationResponse, err error) {
	response = CreateCreateVSwitchCidrReservationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVSwitchCidrReservationWithChan invokes the vpc.CreateVSwitchCidrReservation API asynchronously
func (client *Client) CreateVSwitchCidrReservationWithChan(request *CreateVSwitchCidrReservationRequest) (<-chan *CreateVSwitchCidrReservationResponse, <-chan error) {
	responseChan := make(chan *CreateVSwitchCidrReservationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVSwitchCidrReservation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVSwitchCidrReservationWithCallback invokes the vpc.CreateVSwitchCidrReservation API asynchronously
func (client *Client) CreateVSwitchCidrReservationWithCallback(request *CreateVSwitchCidrReservationRequest, callback func(response *CreateVSwitchCidrReservationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVSwitchCidrReservationResponse
		var err error
		defer close(result)
		response, err = client.CreateVSwitchCidrReservation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVSwitchCidrReservationRequest is the request struct for api CreateVSwitchCidrReservation
type CreateVSwitchCidrReservationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                   requests.Integer                   `position:"Query" name:"ResourceOwnerId"`
	ClientToken                       string                             `position:"Query" name:"ClientToken"`
	VSwitchCidrReservationType        string                             `position:"Query" name:"VSwitchCidrReservationType"`
	VSwitchCidrReservationDescription string                             `position:"Query" name:"VSwitchCidrReservationDescription"`
	VSwitchCidrReservationName        string                             `position:"Query" name:"VSwitchCidrReservationName"`
	IpVersion                         string                             `position:"Query" name:"IpVersion"`
	Tag                               *[]CreateVSwitchCidrReservationTag `position:"Query" name:"Tag"  type:"Repeated"`
	DryRun                            requests.Boolean                   `position:"Query" name:"DryRun"`
	ResourceOwnerAccount              string                             `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                      string                             `position:"Query" name:"OwnerAccount"`
	OwnerId                           requests.Integer                   `position:"Query" name:"OwnerId"`
	VSwitchId                         string                             `position:"Query" name:"VSwitchId"`
	VSwitchCidrReservationMask        string                             `position:"Query" name:"VSwitchCidrReservationMask"`
	VSwitchCidrReservationCidr        string                             `position:"Query" name:"VSwitchCidrReservationCidr"`
}

// CreateVSwitchCidrReservationTag is a repeated param struct in CreateVSwitchCidrReservationRequest
type CreateVSwitchCidrReservationTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateVSwitchCidrReservationResponse is the response struct for api CreateVSwitchCidrReservation
type CreateVSwitchCidrReservationResponse struct {
	*responses.BaseResponse
	VSwitchCidrReservationId string `json:"VSwitchCidrReservationId" xml:"VSwitchCidrReservationId"`
	RequestId                string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateVSwitchCidrReservationRequest creates a request to invoke CreateVSwitchCidrReservation API
func CreateCreateVSwitchCidrReservationRequest() (request *CreateVSwitchCidrReservationRequest) {
	request = &CreateVSwitchCidrReservationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateVSwitchCidrReservation", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVSwitchCidrReservationResponse creates a response to parse from CreateVSwitchCidrReservation response
func CreateCreateVSwitchCidrReservationResponse() (response *CreateVSwitchCidrReservationResponse) {
	response = &CreateVSwitchCidrReservationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
