package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetVodDomainSSLCertificate invokes the vod.SetVodDomainSSLCertificate API synchronously
func (client *Client) SetVodDomainSSLCertificate(request *SetVodDomainSSLCertificateRequest) (response *SetVodDomainSSLCertificateResponse, err error) {
	response = CreateSetVodDomainSSLCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// SetVodDomainSSLCertificateWithChan invokes the vod.SetVodDomainSSLCertificate API asynchronously
func (client *Client) SetVodDomainSSLCertificateWithChan(request *SetVodDomainSSLCertificateRequest) (<-chan *SetVodDomainSSLCertificateResponse, <-chan error) {
	responseChan := make(chan *SetVodDomainSSLCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetVodDomainSSLCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetVodDomainSSLCertificateWithCallback invokes the vod.SetVodDomainSSLCertificate API asynchronously
func (client *Client) SetVodDomainSSLCertificateWithCallback(request *SetVodDomainSSLCertificateRequest, callback func(response *SetVodDomainSSLCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetVodDomainSSLCertificateResponse
		var err error
		defer close(result)
		response, err = client.SetVodDomainSSLCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetVodDomainSSLCertificateRequest is the request struct for api SetVodDomainSSLCertificate
type SetVodDomainSSLCertificateRequest struct {
	*requests.RpcRequest
	SSLProtocol   string           `position:"Query" name:"SSLProtocol"`
	CertId        requests.Integer `position:"Query" name:"CertId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	CertType      string           `position:"Query" name:"CertType"`
	SSLPri        string           `position:"Query" name:"SSLPri"`
	CertRegion    string           `position:"Query" name:"CertRegion"`
	CertName      string           `position:"Query" name:"CertName"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	Env           string           `position:"Query" name:"Env"`
	SSLPub        string           `position:"Query" name:"SSLPub"`
}

// SetVodDomainSSLCertificateResponse is the response struct for api SetVodDomainSSLCertificate
type SetVodDomainSSLCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetVodDomainSSLCertificateRequest creates a request to invoke SetVodDomainSSLCertificate API
func CreateSetVodDomainSSLCertificateRequest() (request *SetVodDomainSSLCertificateRequest) {
	request = &SetVodDomainSSLCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "SetVodDomainSSLCertificate", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetVodDomainSSLCertificateResponse creates a response to parse from SetVodDomainSSLCertificate response
func CreateSetVodDomainSSLCertificateResponse() (response *SetVodDomainSSLCertificateResponse) {
	response = &SetVodDomainSSLCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
