package viapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelWaitingAsyncJob invokes the viapi.CancelWaitingAsyncJob API synchronously
func (client *Client) CancelWaitingAsyncJob(request *CancelWaitingAsyncJobRequest) (response *CancelWaitingAsyncJobResponse, err error) {
	response = CreateCancelWaitingAsyncJobResponse()
	err = client.DoAction(request, response)
	return
}

// CancelWaitingAsyncJobWithChan invokes the viapi.CancelWaitingAsyncJob API asynchronously
func (client *Client) CancelWaitingAsyncJobWithChan(request *CancelWaitingAsyncJobRequest) (<-chan *CancelWaitingAsyncJobResponse, <-chan error) {
	responseChan := make(chan *CancelWaitingAsyncJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelWaitingAsyncJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelWaitingAsyncJobWithCallback invokes the viapi.CancelWaitingAsyncJob API asynchronously
func (client *Client) CancelWaitingAsyncJobWithCallback(request *CancelWaitingAsyncJobRequest, callback func(response *CancelWaitingAsyncJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelWaitingAsyncJobResponse
		var err error
		defer close(result)
		response, err = client.CancelWaitingAsyncJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelWaitingAsyncJobRequest is the request struct for api CancelWaitingAsyncJob
type CancelWaitingAsyncJobRequest struct {
	*requests.RpcRequest
	JobId string           `position:"Body" name:"JobId"`
	Async requests.Boolean `position:"Body" name:"Async"`
}

// CancelWaitingAsyncJobResponse is the response struct for api CancelWaitingAsyncJob
type CancelWaitingAsyncJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	HttpCode  string `json:"HttpCode" xml:"HttpCode"`
}

// CreateCancelWaitingAsyncJobRequest creates a request to invoke CancelWaitingAsyncJob API
func CreateCancelWaitingAsyncJobRequest() (request *CancelWaitingAsyncJobRequest) {
	request = &CancelWaitingAsyncJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi", "2023-01-17", "CancelWaitingAsyncJob", "viapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelWaitingAsyncJobResponse creates a response to parse from CancelWaitingAsyncJob response
func CreateCancelWaitingAsyncJobResponse() (response *CancelWaitingAsyncJobResponse) {
	response = &CancelWaitingAsyncJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
