package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryContentInfo invokes the unimkt.QueryContentInfo API synchronously
func (client *Client) QueryContentInfo(request *QueryContentInfoRequest) (response *QueryContentInfoResponse, err error) {
	response = CreateQueryContentInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryContentInfoWithChan invokes the unimkt.QueryContentInfo API asynchronously
func (client *Client) QueryContentInfoWithChan(request *QueryContentInfoRequest) (<-chan *QueryContentInfoResponse, <-chan error) {
	responseChan := make(chan *QueryContentInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryContentInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryContentInfoWithCallback invokes the unimkt.QueryContentInfo API asynchronously
func (client *Client) QueryContentInfoWithCallback(request *QueryContentInfoRequest, callback func(response *QueryContentInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryContentInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryContentInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryContentInfoRequest is the request struct for api QueryContentInfo
type QueryContentInfoRequest struct {
	*requests.RpcRequest
	ContentId requests.Integer `position:"Query" name:"ContentId"`
}

// QueryContentInfoResponse is the response struct for api QueryContentInfo
type QueryContentInfoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Code         int    `json:"Code" xml:"Code"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryContentInfoRequest creates a request to invoke QueryContentInfo API
func CreateQueryContentInfoRequest() (request *QueryContentInfoRequest) {
	request = &QueryContentInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryContentInfo", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryContentInfoResponse creates a response to parse from QueryContentInfo response
func CreateQueryContentInfoResponse() (response *QueryContentInfoResponse) {
	response = &QueryContentInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
