package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProjectMembers invokes the teambition_aliyun.GetProjectMembers API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getprojectmembers.html
func (client *Client) GetProjectMembers(request *GetProjectMembersRequest) (response *GetProjectMembersResponse, err error) {
	response = CreateGetProjectMembersResponse()
	err = client.DoAction(request, response)
	return
}

// GetProjectMembersWithChan invokes the teambition_aliyun.GetProjectMembers API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getprojectmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProjectMembersWithChan(request *GetProjectMembersRequest) (<-chan *GetProjectMembersResponse, <-chan error) {
	responseChan := make(chan *GetProjectMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProjectMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProjectMembersWithCallback invokes the teambition_aliyun.GetProjectMembers API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getprojectmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProjectMembersWithCallback(request *GetProjectMembersRequest, callback func(response *GetProjectMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProjectMembersResponse
		var err error
		defer close(result)
		response, err = client.GetProjectMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProjectMembersRequest is the request struct for api GetProjectMembers
type GetProjectMembersRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// GetProjectMembersResponse is the response struct for api GetProjectMembers
type GetProjectMembersResponse struct {
	*responses.BaseResponse
	Successful bool     `json:"Successful" xml:"Successful"`
	ErrorCode  string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	Object     []Member `json:"Object" xml:"Object"`
}

// CreateGetProjectMembersRequest creates a request to invoke GetProjectMembers API
func CreateGetProjectMembersRequest() (request *GetProjectMembersRequest) {
	request = &GetProjectMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "GetProjectMembers", "", "")
	request.Method = requests.POST
	return
}

// CreateGetProjectMembersResponse creates a response to parse from GetProjectMembers response
func CreateGetProjectMembersResponse() (response *GetProjectMembersResponse) {
	response = &GetProjectMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
