package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartInstances invokes the swas_open.StartInstances API synchronously
func (client *Client) StartInstances(request *StartInstancesRequest) (response *StartInstancesResponse, err error) {
	response = CreateStartInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// StartInstancesWithChan invokes the swas_open.StartInstances API asynchronously
func (client *Client) StartInstancesWithChan(request *StartInstancesRequest) (<-chan *StartInstancesResponse, <-chan error) {
	responseChan := make(chan *StartInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartInstancesWithCallback invokes the swas_open.StartInstances API asynchronously
func (client *Client) StartInstancesWithCallback(request *StartInstancesRequest, callback func(response *StartInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartInstancesResponse
		var err error
		defer close(result)
		response, err = client.StartInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartInstancesRequest is the request struct for api StartInstances
type StartInstancesRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	InstanceIds string `position:"Query" name:"InstanceIds"`
}

// StartInstancesResponse is the response struct for api StartInstances
type StartInstancesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartInstancesRequest creates a request to invoke StartInstances API
func CreateStartInstancesRequest() (request *StartInstancesRequest) {
	request = &StartInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "StartInstances", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartInstancesResponse creates a response to parse from StartInstances response
func CreateStartInstancesResponse() (response *StartInstancesResponse) {
	response = &StartInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
