package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetDatabaseAccountPassword invokes the swas_open.ResetDatabaseAccountPassword API synchronously
func (client *Client) ResetDatabaseAccountPassword(request *ResetDatabaseAccountPasswordRequest) (response *ResetDatabaseAccountPasswordResponse, err error) {
	response = CreateResetDatabaseAccountPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ResetDatabaseAccountPasswordWithChan invokes the swas_open.ResetDatabaseAccountPassword API asynchronously
func (client *Client) ResetDatabaseAccountPasswordWithChan(request *ResetDatabaseAccountPasswordRequest) (<-chan *ResetDatabaseAccountPasswordResponse, <-chan error) {
	responseChan := make(chan *ResetDatabaseAccountPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetDatabaseAccountPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetDatabaseAccountPasswordWithCallback invokes the swas_open.ResetDatabaseAccountPassword API asynchronously
func (client *Client) ResetDatabaseAccountPasswordWithCallback(request *ResetDatabaseAccountPasswordRequest, callback func(response *ResetDatabaseAccountPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetDatabaseAccountPasswordResponse
		var err error
		defer close(result)
		response, err = client.ResetDatabaseAccountPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetDatabaseAccountPasswordRequest is the request struct for api ResetDatabaseAccountPassword
type ResetDatabaseAccountPasswordRequest struct {
	*requests.RpcRequest
	ClientToken        string `position:"Query" name:"ClientToken"`
	DatabaseInstanceId string `position:"Query" name:"DatabaseInstanceId"`
	AccountPassword    string `position:"Query" name:"AccountPassword"`
}

// ResetDatabaseAccountPasswordResponse is the response struct for api ResetDatabaseAccountPassword
type ResetDatabaseAccountPasswordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetDatabaseAccountPasswordRequest creates a request to invoke ResetDatabaseAccountPassword API
func CreateResetDatabaseAccountPasswordRequest() (request *ResetDatabaseAccountPasswordRequest) {
	request = &ResetDatabaseAccountPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ResetDatabaseAccountPassword", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResetDatabaseAccountPasswordResponse creates a response to parse from ResetDatabaseAccountPassword response
func CreateResetDatabaseAccountPasswordResponse() (response *ResetDatabaseAccountPasswordResponse) {
	response = &ResetDatabaseAccountPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
