package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LoginInstance invokes the swas_open.LoginInstance API synchronously
func (client *Client) LoginInstance(request *LoginInstanceRequest) (response *LoginInstanceResponse, err error) {
	response = CreateLoginInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// LoginInstanceWithChan invokes the swas_open.LoginInstance API asynchronously
func (client *Client) LoginInstanceWithChan(request *LoginInstanceRequest) (<-chan *LoginInstanceResponse, <-chan error) {
	responseChan := make(chan *LoginInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LoginInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LoginInstanceWithCallback invokes the swas_open.LoginInstance API asynchronously
func (client *Client) LoginInstanceWithCallback(request *LoginInstanceRequest, callback func(response *LoginInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LoginInstanceResponse
		var err error
		defer close(result)
		response, err = client.LoginInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LoginInstanceRequest is the request struct for api LoginInstance
type LoginInstanceRequest struct {
	*requests.RpcRequest
	Password   string           `position:"Query" name:"Password"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	Port       requests.Integer `position:"Query" name:"Port"`
	Username   string           `position:"Query" name:"Username"`
}

// LoginInstanceResponse is the response struct for api LoginInstance
type LoginInstanceResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	RedirectUrl string `json:"RedirectUrl" xml:"RedirectUrl"`
}

// CreateLoginInstanceRequest creates a request to invoke LoginInstance API
func CreateLoginInstanceRequest() (request *LoginInstanceRequest) {
	request = &LoginInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "LoginInstance", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLoginInstanceResponse creates a response to parse from LoginInstance response
func CreateLoginInstanceResponse() (response *LoginInstanceResponse) {
	response = &LoginInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
