package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePlaybookNumberMetrics invokes the sophonsoar.DescribePlaybookNumberMetrics API synchronously
func (client *Client) DescribePlaybookNumberMetrics(request *DescribePlaybookNumberMetricsRequest) (response *DescribePlaybookNumberMetricsResponse, err error) {
	response = CreateDescribePlaybookNumberMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePlaybookNumberMetricsWithChan invokes the sophonsoar.DescribePlaybookNumberMetrics API asynchronously
func (client *Client) DescribePlaybookNumberMetricsWithChan(request *DescribePlaybookNumberMetricsRequest) (<-chan *DescribePlaybookNumberMetricsResponse, <-chan error) {
	responseChan := make(chan *DescribePlaybookNumberMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePlaybookNumberMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePlaybookNumberMetricsWithCallback invokes the sophonsoar.DescribePlaybookNumberMetrics API asynchronously
func (client *Client) DescribePlaybookNumberMetricsWithCallback(request *DescribePlaybookNumberMetricsRequest, callback func(response *DescribePlaybookNumberMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePlaybookNumberMetricsResponse
		var err error
		defer close(result)
		response, err = client.DescribePlaybookNumberMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePlaybookNumberMetricsRequest is the request struct for api DescribePlaybookNumberMetrics
type DescribePlaybookNumberMetricsRequest struct {
	*requests.RpcRequest
	RoleFor  string `position:"Query" name:"RoleFor"`
	RoleType string `position:"Query" name:"RoleType"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribePlaybookNumberMetricsResponse is the response struct for api DescribePlaybookNumberMetrics
type DescribePlaybookNumberMetricsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Metrics   Metrics `json:"Metrics" xml:"Metrics"`
}

// CreateDescribePlaybookNumberMetricsRequest creates a request to invoke DescribePlaybookNumberMetrics API
func CreateDescribePlaybookNumberMetricsRequest() (request *DescribePlaybookNumberMetricsRequest) {
	request = &DescribePlaybookNumberMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribePlaybookNumberMetrics", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribePlaybookNumberMetricsResponse creates a response to parse from DescribePlaybookNumberMetrics response
func CreateDescribePlaybookNumberMetricsResponse() (response *DescribePlaybookNumberMetricsResponse) {
	response = &DescribePlaybookNumberMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
