package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGatewayFileShares invokes the sgw.DeleteGatewayFileShares API synchronously
func (client *Client) DeleteGatewayFileShares(request *DeleteGatewayFileSharesRequest) (response *DeleteGatewayFileSharesResponse, err error) {
	response = CreateDeleteGatewayFileSharesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGatewayFileSharesWithChan invokes the sgw.DeleteGatewayFileShares API asynchronously
func (client *Client) DeleteGatewayFileSharesWithChan(request *DeleteGatewayFileSharesRequest) (<-chan *DeleteGatewayFileSharesResponse, <-chan error) {
	responseChan := make(chan *DeleteGatewayFileSharesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGatewayFileShares(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGatewayFileSharesWithCallback invokes the sgw.DeleteGatewayFileShares API asynchronously
func (client *Client) DeleteGatewayFileSharesWithCallback(request *DeleteGatewayFileSharesRequest, callback func(response *DeleteGatewayFileSharesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGatewayFileSharesResponse
		var err error
		defer close(result)
		response, err = client.DeleteGatewayFileShares(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGatewayFileSharesRequest is the request struct for api DeleteGatewayFileShares
type DeleteGatewayFileSharesRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	IndexId       string           `position:"Query" name:"IndexId"`
	Force         requests.Boolean `position:"Query" name:"Force"`
	GatewayId     string           `position:"Query" name:"GatewayId"`
}

// DeleteGatewayFileSharesResponse is the response struct for api DeleteGatewayFileShares
type DeleteGatewayFileSharesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateDeleteGatewayFileSharesRequest creates a request to invoke DeleteGatewayFileShares API
func CreateDeleteGatewayFileSharesRequest() (request *DeleteGatewayFileSharesRequest) {
	request = &DeleteGatewayFileSharesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DeleteGatewayFileShares", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteGatewayFileSharesResponse creates a response to parse from DeleteGatewayFileShares response
func CreateDeleteGatewayFileSharesResponse() (response *DeleteGatewayFileSharesResponse) {
	response = &DeleteGatewayFileSharesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
