package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateRerunJob invokes the schedulerx3.OperateRerunJob API synchronously
func (client *Client) OperateRerunJob(request *OperateRerunJobRequest) (response *OperateRerunJobResponse, err error) {
	response = CreateOperateRerunJobResponse()
	err = client.DoAction(request, response)
	return
}

// OperateRerunJobWithChan invokes the schedulerx3.OperateRerunJob API asynchronously
func (client *Client) OperateRerunJobWithChan(request *OperateRerunJobRequest) (<-chan *OperateRerunJobResponse, <-chan error) {
	responseChan := make(chan *OperateRerunJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateRerunJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateRerunJobWithCallback invokes the schedulerx3.OperateRerunJob API asynchronously
func (client *Client) OperateRerunJobWithCallback(request *OperateRerunJobRequest, callback func(response *OperateRerunJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateRerunJobResponse
		var err error
		defer close(result)
		response, err = client.OperateRerunJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateRerunJobRequest is the request struct for api OperateRerunJob
type OperateRerunJobRequest struct {
	*requests.RpcRequest
	MseSessionId string           `position:"Query" name:"MseSessionId"`
	DataTime     string           `position:"Query" name:"DataTime"`
	StartDate    requests.Integer `position:"Query" name:"StartDate"`
	JobId        requests.Integer `position:"Query" name:"JobId"`
	AppName      string           `position:"Query" name:"AppName"`
	ClusterId    string           `position:"Query" name:"ClusterId"`
	EndDate      requests.Integer `position:"Query" name:"EndDate"`
}

// OperateRerunJobResponse is the response struct for api OperateRerunJob
type OperateRerunJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateOperateRerunJobRequest creates a request to invoke OperateRerunJob API
func CreateOperateRerunJobRequest() (request *OperateRerunJobRequest) {
	request = &OperateRerunJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "OperateRerunJob", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateRerunJobResponse creates a response to parse from OperateRerunJob response
func CreateOperateRerunJobResponse() (response *OperateRerunJobResponse) {
	response = &OperateRerunJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
