package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJob invokes the sae.DescribeJob API synchronously
func (client *Client) DescribeJob(request *DescribeJobRequest) (response *DescribeJobResponse, err error) {
	response = CreateDescribeJobResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJobWithChan invokes the sae.DescribeJob API asynchronously
func (client *Client) DescribeJobWithChan(request *DescribeJobRequest) (<-chan *DescribeJobResponse, <-chan error) {
	responseChan := make(chan *DescribeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJobWithCallback invokes the sae.DescribeJob API asynchronously
func (client *Client) DescribeJobWithCallback(request *DescribeJobRequest, callback func(response *DescribeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJobResponse
		var err error
		defer close(result)
		response, err = client.DescribeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJobRequest is the request struct for api DescribeJob
type DescribeJobRequest struct {
	*requests.RoaRequest
	JobId     string `position:"Query" name:"JobId"`
	VersionId string `position:"Query" name:"VersionId"`
	AppId     string `position:"Query" name:"AppId"`
}

// DescribeJobResponse is the response struct for api DescribeJob
type DescribeJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeJobRequest creates a request to invoke DescribeJob API
func CreateDescribeJobRequest() (request *DescribeJobRequest) {
	request = &DescribeJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DescribeJob", "/pop/v1/sam/job/describeJob", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeJobResponse creates a response to parse from DescribeJob response
func CreateDescribeJobResponse() (response *DescribeJobResponse) {
	response = &DescribeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
