package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckMarketingAudienceExportStatus invokes the retailadvqa_public.CheckMarketingAudienceExportStatus API synchronously
func (client *Client) CheckMarketingAudienceExportStatus(request *CheckMarketingAudienceExportStatusRequest) (response *CheckMarketingAudienceExportStatusResponse, err error) {
	response = CreateCheckMarketingAudienceExportStatusResponse()
	err = client.DoAction(request, response)
	return
}

// CheckMarketingAudienceExportStatusWithChan invokes the retailadvqa_public.CheckMarketingAudienceExportStatus API asynchronously
func (client *Client) CheckMarketingAudienceExportStatusWithChan(request *CheckMarketingAudienceExportStatusRequest) (<-chan *CheckMarketingAudienceExportStatusResponse, <-chan error) {
	responseChan := make(chan *CheckMarketingAudienceExportStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckMarketingAudienceExportStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckMarketingAudienceExportStatusWithCallback invokes the retailadvqa_public.CheckMarketingAudienceExportStatus API asynchronously
func (client *Client) CheckMarketingAudienceExportStatusWithCallback(request *CheckMarketingAudienceExportStatusRequest, callback func(response *CheckMarketingAudienceExportStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckMarketingAudienceExportStatusResponse
		var err error
		defer close(result)
		response, err = client.CheckMarketingAudienceExportStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckMarketingAudienceExportStatusRequest is the request struct for api CheckMarketingAudienceExportStatus
type CheckMarketingAudienceExportStatusRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	AudienceId  string `position:"Query" name:"AudienceId"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// CheckMarketingAudienceExportStatusResponse is the response struct for api CheckMarketingAudienceExportStatus
type CheckMarketingAudienceExportStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCheckMarketingAudienceExportStatusRequest creates a request to invoke CheckMarketingAudienceExportStatus API
func CreateCheckMarketingAudienceExportStatusRequest() (request *CheckMarketingAudienceExportStatusRequest) {
	request = &CheckMarketingAudienceExportStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "CheckMarketingAudienceExportStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckMarketingAudienceExportStatusResponse creates a response to parse from CheckMarketingAudienceExportStatus response
func CreateCheckMarketingAudienceExportStatusResponse() (response *CheckMarketingAudienceExportStatusResponse) {
	response = &CheckMarketingAudienceExportStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
