package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSharedTargets invokes the resourcesharing.ListSharedTargets API synchronously
func (client *Client) ListSharedTargets(request *ListSharedTargetsRequest) (response *ListSharedTargetsResponse, err error) {
	response = CreateListSharedTargetsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSharedTargetsWithChan invokes the resourcesharing.ListSharedTargets API asynchronously
func (client *Client) ListSharedTargetsWithChan(request *ListSharedTargetsRequest) (<-chan *ListSharedTargetsResponse, <-chan error) {
	responseChan := make(chan *ListSharedTargetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSharedTargets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSharedTargetsWithCallback invokes the resourcesharing.ListSharedTargets API asynchronously
func (client *Client) ListSharedTargetsWithCallback(request *ListSharedTargetsRequest, callback func(response *ListSharedTargetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSharedTargetsResponse
		var err error
		defer close(result)
		response, err = client.ListSharedTargets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSharedTargetsRequest is the request struct for api ListSharedTargets
type ListSharedTargetsRequest struct {
	*requests.RpcRequest
	Targets          *[]string        `position:"Query" name:"Targets"  type:"Repeated"`
	NextToken        string           `position:"Query" name:"NextToken"`
	ResourceShareIds *[]string        `position:"Query" name:"ResourceShareIds"  type:"Repeated"`
	ResourceId       string           `position:"Query" name:"ResourceId"`
	ResourceOwner    string           `position:"Query" name:"ResourceOwner"`
	ResourceType     string           `position:"Query" name:"ResourceType"`
	MaxResults       requests.Integer `position:"Query" name:"MaxResults"`
}

// ListSharedTargetsResponse is the response struct for api ListSharedTargets
type ListSharedTargetsResponse struct {
	*responses.BaseResponse
	NextToken     string         `json:"NextToken" xml:"NextToken"`
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	SharedTargets []SharedTarget `json:"SharedTargets" xml:"SharedTargets"`
}

// CreateListSharedTargetsRequest creates a request to invoke ListSharedTargets API
func CreateListSharedTargetsRequest() (request *ListSharedTargetsRequest) {
	request = &ListSharedTargetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "ListSharedTargets", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSharedTargetsResponse creates a response to parse from ListSharedTargets response
func CreateListSharedTargetsResponse() (response *ListSharedTargetsResponse) {
	response = &ListSharedTargetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
