package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisassociateResourceSharePermission invokes the resourcesharing.DisassociateResourceSharePermission API synchronously
func (client *Client) DisassociateResourceSharePermission(request *DisassociateResourceSharePermissionRequest) (response *DisassociateResourceSharePermissionResponse, err error) {
	response = CreateDisassociateResourceSharePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// DisassociateResourceSharePermissionWithChan invokes the resourcesharing.DisassociateResourceSharePermission API asynchronously
func (client *Client) DisassociateResourceSharePermissionWithChan(request *DisassociateResourceSharePermissionRequest) (<-chan *DisassociateResourceSharePermissionResponse, <-chan error) {
	responseChan := make(chan *DisassociateResourceSharePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisassociateResourceSharePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisassociateResourceSharePermissionWithCallback invokes the resourcesharing.DisassociateResourceSharePermission API asynchronously
func (client *Client) DisassociateResourceSharePermissionWithCallback(request *DisassociateResourceSharePermissionRequest, callback func(response *DisassociateResourceSharePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisassociateResourceSharePermissionResponse
		var err error
		defer close(result)
		response, err = client.DisassociateResourceSharePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisassociateResourceSharePermissionRequest is the request struct for api DisassociateResourceSharePermission
type DisassociateResourceSharePermissionRequest struct {
	*requests.RpcRequest
	PermissionName  string `position:"Query" name:"PermissionName"`
	ResourceShareId string `position:"Query" name:"ResourceShareId"`
}

// DisassociateResourceSharePermissionResponse is the response struct for api DisassociateResourceSharePermission
type DisassociateResourceSharePermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisassociateResourceSharePermissionRequest creates a request to invoke DisassociateResourceSharePermission API
func CreateDisassociateResourceSharePermissionRequest() (request *DisassociateResourceSharePermissionRequest) {
	request = &DisassociateResourceSharePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "DisassociateResourceSharePermission", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisassociateResourceSharePermissionResponse creates a response to parse from DisassociateResourceSharePermission response
func CreateDisassociateResourceSharePermissionResponse() (response *DisassociateResourceSharePermissionResponse) {
	response = &DisassociateResourceSharePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
