package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceShare invokes the resourcesharing.DeleteResourceShare API synchronously
func (client *Client) DeleteResourceShare(request *DeleteResourceShareRequest) (response *DeleteResourceShareResponse, err error) {
	response = CreateDeleteResourceShareResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceShareWithChan invokes the resourcesharing.DeleteResourceShare API asynchronously
func (client *Client) DeleteResourceShareWithChan(request *DeleteResourceShareRequest) (<-chan *DeleteResourceShareResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceShareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceShare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceShareWithCallback invokes the resourcesharing.DeleteResourceShare API asynchronously
func (client *Client) DeleteResourceShareWithCallback(request *DeleteResourceShareRequest, callback func(response *DeleteResourceShareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceShareResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceShare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceShareRequest is the request struct for api DeleteResourceShare
type DeleteResourceShareRequest struct {
	*requests.RpcRequest
	ResourceShareId string `position:"Query" name:"ResourceShareId"`
}

// DeleteResourceShareResponse is the response struct for api DeleteResourceShare
type DeleteResourceShareResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteResourceShareRequest creates a request to invoke DeleteResourceShare API
func CreateDeleteResourceShareRequest() (request *DeleteResourceShareRequest) {
	request = &DeleteResourceShareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "DeleteResourceShare", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteResourceShareResponse creates a response to parse from DeleteResourceShare response
func CreateDeleteResourceShareResponse() (response *DeleteResourceShareResponse) {
	response = &DeleteResourceShareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
