package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateResourceShare invokes the resourcesharing.CreateResourceShare API synchronously
func (client *Client) CreateResourceShare(request *CreateResourceShareRequest) (response *CreateResourceShareResponse, err error) {
	response = CreateCreateResourceShareResponse()
	err = client.DoAction(request, response)
	return
}

// CreateResourceShareWithChan invokes the resourcesharing.CreateResourceShare API asynchronously
func (client *Client) CreateResourceShareWithChan(request *CreateResourceShareRequest) (<-chan *CreateResourceShareResponse, <-chan error) {
	responseChan := make(chan *CreateResourceShareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateResourceShare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateResourceShareWithCallback invokes the resourcesharing.CreateResourceShare API asynchronously
func (client *Client) CreateResourceShareWithCallback(request *CreateResourceShareRequest, callback func(response *CreateResourceShareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateResourceShareResponse
		var err error
		defer close(result)
		response, err = client.CreateResourceShare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateResourceShareRequest is the request struct for api CreateResourceShare
type CreateResourceShareRequest struct {
	*requests.RpcRequest
	ResourceShareName    string                                 `position:"Query" name:"ResourceShareName"`
	Targets              *[]string                              `position:"Query" name:"Targets"  type:"Repeated"`
	ResourceGroupId      string                                 `position:"Query" name:"ResourceGroupId"`
	Resources            *[]CreateResourceShareResources        `position:"Query" name:"Resources"  type:"Repeated"`
	AllowExternalTargets requests.Boolean                       `position:"Query" name:"AllowExternalTargets"`
	PermissionNames      *[]string                              `position:"Query" name:"PermissionNames"  type:"Repeated"`
	TargetProperties     *[]CreateResourceShareTargetProperties `position:"Query" name:"TargetProperties"  type:"Repeated"`
}

// CreateResourceShareTargetProperties is a repeated param struct in CreateResourceShareRequest
type CreateResourceShareTargetProperties struct {
	TargetId string `name:"TargetId"`
	Property string `name:"Property"`
}

// CreateResourceShareResources is a repeated param struct in CreateResourceShareRequest
type CreateResourceShareResources struct {
	ResourceId   string `name:"ResourceId"`
	ResourceType string `name:"ResourceType"`
}

// CreateResourceShareResponse is the response struct for api CreateResourceShare
type CreateResourceShareResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResourceShare ResourceShare `json:"ResourceShare" xml:"ResourceShare"`
}

// CreateCreateResourceShareRequest creates a request to invoke CreateResourceShare API
func CreateCreateResourceShareRequest() (request *CreateResourceShareRequest) {
	request = &CreateResourceShareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "CreateResourceShare", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateResourceShareResponse creates a response to parse from CreateResourceShare response
func CreateCreateResourceShareResponse() (response *CreateResourceShareResponse) {
	response = &CreateResourceShareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
