package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAutoGroupingRules invokes the resourcemanager.ListAutoGroupingRules API synchronously
func (client *Client) ListAutoGroupingRules(request *ListAutoGroupingRulesRequest) (response *ListAutoGroupingRulesResponse, err error) {
	response = CreateListAutoGroupingRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAutoGroupingRulesWithChan invokes the resourcemanager.ListAutoGroupingRules API asynchronously
func (client *Client) ListAutoGroupingRulesWithChan(request *ListAutoGroupingRulesRequest) (<-chan *ListAutoGroupingRulesResponse, <-chan error) {
	responseChan := make(chan *ListAutoGroupingRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAutoGroupingRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAutoGroupingRulesWithCallback invokes the resourcemanager.ListAutoGroupingRules API asynchronously
func (client *Client) ListAutoGroupingRulesWithCallback(request *ListAutoGroupingRulesRequest, callback func(response *ListAutoGroupingRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAutoGroupingRulesResponse
		var err error
		defer close(result)
		response, err = client.ListAutoGroupingRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAutoGroupingRulesRequest is the request struct for api ListAutoGroupingRules
type ListAutoGroupingRulesRequest struct {
	*requests.RpcRequest
	RuleName   string           `position:"Query" name:"RuleName"`
	NextToken  string           `position:"Query" name:"NextToken"`
	RuleType   string           `position:"Query" name:"RuleType"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	RuleId     string           `position:"Query" name:"RuleId"`
}

// ListAutoGroupingRulesResponse is the response struct for api ListAutoGroupingRules
type ListAutoGroupingRulesResponse struct {
	*responses.BaseResponse
	NextToken  string `json:"NextToken" xml:"NextToken"`
	MaxResults int    `json:"MaxResults" xml:"MaxResults"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Rules      []Rule `json:"Rules" xml:"Rules"`
}

// CreateListAutoGroupingRulesRequest creates a request to invoke ListAutoGroupingRules API
func CreateListAutoGroupingRulesRequest() (request *ListAutoGroupingRulesRequest) {
	request = &ListAutoGroupingRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ListAutoGroupingRules", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAutoGroupingRulesResponse creates a response to parse from ListAutoGroupingRules response
func CreateListAutoGroupingRulesResponse() (response *ListAutoGroupingRulesResponse) {
	response = &ListAutoGroupingRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
