package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMaskingRules invokes the rds.DescribeMaskingRules API synchronously
func (client *Client) DescribeMaskingRules(request *DescribeMaskingRulesRequest) (response *DescribeMaskingRulesResponse, err error) {
	response = CreateDescribeMaskingRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMaskingRulesWithChan invokes the rds.DescribeMaskingRules API asynchronously
func (client *Client) DescribeMaskingRulesWithChan(request *DescribeMaskingRulesRequest) (<-chan *DescribeMaskingRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeMaskingRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMaskingRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMaskingRulesWithCallback invokes the rds.DescribeMaskingRules API asynchronously
func (client *Client) DescribeMaskingRulesWithCallback(request *DescribeMaskingRulesRequest, callback func(response *DescribeMaskingRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMaskingRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeMaskingRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMaskingRulesRequest is the request struct for api DescribeMaskingRules
type DescribeMaskingRulesRequest struct {
	*requests.RpcRequest
	DBInstanceName       string           `position:"Query" name:"DBInstanceName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RuleName             string           `position:"Query" name:"RuleName"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
}

// DescribeMaskingRulesResponse is the response struct for api DescribeMaskingRules
type DescribeMaskingRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeMaskingRulesRequest creates a request to invoke DescribeMaskingRules API
func CreateDescribeMaskingRulesRequest() (request *DescribeMaskingRulesRequest) {
	request = &DescribeMaskingRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeMaskingRules", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMaskingRulesResponse creates a response to parse from DescribeMaskingRules response
func CreateDescribeMaskingRulesResponse() (response *DescribeMaskingRulesResponse) {
	response = &DescribeMaskingRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
