package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResizeTairKVCacheCustomInstanceDisk invokes the r_kvstore.ResizeTairKVCacheCustomInstanceDisk API synchronously
func (client *Client) ResizeTairKVCacheCustomInstanceDisk(request *ResizeTairKVCacheCustomInstanceDiskRequest) (response *ResizeTairKVCacheCustomInstanceDiskResponse, err error) {
	response = CreateResizeTairKVCacheCustomInstanceDiskResponse()
	err = client.DoAction(request, response)
	return
}

// ResizeTairKVCacheCustomInstanceDiskWithChan invokes the r_kvstore.ResizeTairKVCacheCustomInstanceDisk API asynchronously
func (client *Client) ResizeTairKVCacheCustomInstanceDiskWithChan(request *ResizeTairKVCacheCustomInstanceDiskRequest) (<-chan *ResizeTairKVCacheCustomInstanceDiskResponse, <-chan error) {
	responseChan := make(chan *ResizeTairKVCacheCustomInstanceDiskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResizeTairKVCacheCustomInstanceDisk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResizeTairKVCacheCustomInstanceDiskWithCallback invokes the r_kvstore.ResizeTairKVCacheCustomInstanceDisk API asynchronously
func (client *Client) ResizeTairKVCacheCustomInstanceDiskWithCallback(request *ResizeTairKVCacheCustomInstanceDiskRequest, callback func(response *ResizeTairKVCacheCustomInstanceDiskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResizeTairKVCacheCustomInstanceDiskResponse
		var err error
		defer close(result)
		response, err = client.ResizeTairKVCacheCustomInstanceDisk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResizeTairKVCacheCustomInstanceDiskRequest is the request struct for api ResizeTairKVCacheCustomInstanceDisk
type ResizeTairKVCacheCustomInstanceDiskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	DiskId               string           `position:"Query" name:"DiskId"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	DiskSize             string           `position:"Query" name:"DiskSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// ResizeTairKVCacheCustomInstanceDiskResponse is the response struct for api ResizeTairKVCacheCustomInstanceDisk
type ResizeTairKVCacheCustomInstanceDiskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateResizeTairKVCacheCustomInstanceDiskRequest creates a request to invoke ResizeTairKVCacheCustomInstanceDisk API
func CreateResizeTairKVCacheCustomInstanceDiskRequest() (request *ResizeTairKVCacheCustomInstanceDiskRequest) {
	request = &ResizeTairKVCacheCustomInstanceDiskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ResizeTairKVCacheCustomInstanceDisk", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResizeTairKVCacheCustomInstanceDiskResponse creates a response to parse from ResizeTairKVCacheCustomInstanceDisk response
func CreateResizeTairKVCacheCustomInstanceDiskResponse() (response *ResizeTairKVCacheCustomInstanceDiskResponse) {
	response = &ResizeTairKVCacheCustomInstanceDiskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
