package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceBandwidth invokes the r_kvstore.ModifyInstanceBandwidth API synchronously
func (client *Client) ModifyInstanceBandwidth(request *ModifyInstanceBandwidthRequest) (response *ModifyInstanceBandwidthResponse, err error) {
	response = CreateModifyInstanceBandwidthResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceBandwidthWithChan invokes the r_kvstore.ModifyInstanceBandwidth API asynchronously
func (client *Client) ModifyInstanceBandwidthWithChan(request *ModifyInstanceBandwidthRequest) (<-chan *ModifyInstanceBandwidthResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceBandwidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceBandwidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceBandwidthWithCallback invokes the r_kvstore.ModifyInstanceBandwidth API asynchronously
func (client *Client) ModifyInstanceBandwidthWithCallback(request *ModifyInstanceBandwidthRequest, callback func(response *ModifyInstanceBandwidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceBandwidthResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceBandwidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceBandwidthRequest is the request struct for api ModifyInstanceBandwidth
type ModifyInstanceBandwidthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken           string           `position:"Query" name:"SecurityToken"`
	Product                 string           `position:"Query" name:"Product"`
	ResourceOwnerAccount    string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string           `position:"Query" name:"OwnerAccount"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	TargetIntranetBandwidth string           `position:"Query" name:"TargetIntranetBandwidth"`
	InstanceId              string           `position:"Query" name:"InstanceId"`
	Category                string           `position:"Query" name:"Category"`
}

// ModifyInstanceBandwidthResponse is the response struct for api ModifyInstanceBandwidth
type ModifyInstanceBandwidthResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceBandwidthRequest creates a request to invoke ModifyInstanceBandwidth API
func CreateModifyInstanceBandwidthRequest() (request *ModifyInstanceBandwidthRequest) {
	request = &ModifyInstanceBandwidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyInstanceBandwidth", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceBandwidthResponse creates a response to parse from ModifyInstanceBandwidth response
func CreateModifyInstanceBandwidthResponse() (response *ModifyInstanceBandwidthResponse) {
	response = &ModifyInstanceBandwidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
