package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRulesV4 invokes the qualitycheck.ListRulesV4 API synchronously
func (client *Client) ListRulesV4(request *ListRulesV4Request) (response *ListRulesV4Response, err error) {
	response = CreateListRulesV4Response()
	err = client.DoAction(request, response)
	return
}

// ListRulesV4WithChan invokes the qualitycheck.ListRulesV4 API asynchronously
func (client *Client) ListRulesV4WithChan(request *ListRulesV4Request) (<-chan *ListRulesV4Response, <-chan error) {
	responseChan := make(chan *ListRulesV4Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRulesV4(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRulesV4WithCallback invokes the qualitycheck.ListRulesV4 API asynchronously
func (client *Client) ListRulesV4WithCallback(request *ListRulesV4Request, callback func(response *ListRulesV4Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRulesV4Response
		var err error
		defer close(result)
		response, err = client.ListRulesV4(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRulesV4Request is the request struct for api ListRulesV4
type ListRulesV4Request struct {
	*requests.RpcRequest
	CreateEmpid         string           `position:"Body" name:"CreateEmpid"`
	UpdateUserId        requests.Integer `position:"Body" name:"UpdateUserId"`
	UpdateStartTime     string           `position:"Body" name:"UpdateStartTime"`
	StartTime           string           `position:"Body" name:"StartTime"`
	Rid                 requests.Integer `position:"Body" name:"Rid"`
	Type                requests.Integer `position:"Body" name:"Type"`
	PageNumber          requests.Integer `position:"Body" name:"PageNumber"`
	RuleIdOrRuleName    string           `position:"Body" name:"RuleIdOrRuleName"`
	PageSize            requests.Integer `position:"Body" name:"PageSize"`
	CreateUserId        requests.Integer `position:"Body" name:"CreateUserId"`
	RuleScoreSingleType requests.Integer `position:"Body" name:"RuleScoreSingleType"`
	SourceType          requests.Integer `position:"Body" name:"SourceType"`
	UpdateEndTime       string           `position:"Body" name:"UpdateEndTime"`
	IsSchemeData        requests.Integer `position:"Body" name:"IsSchemeData"`
	RuleType            requests.Integer `position:"Body" name:"RuleType"`
	CountTotal          requests.Boolean `position:"Body" name:"CountTotal"`
	EndTime             string           `position:"Body" name:"EndTime"`
	SchemeId            requests.Integer `position:"Body" name:"SchemeId"`
	CurrentPage         requests.Integer `position:"Body" name:"CurrentPage"`
	BusinessRange       requests.Integer `position:"Body" name:"BusinessRange"`
	BusinessName        string           `position:"Body" name:"BusinessName"`
	CategoryName        string           `position:"Body" name:"CategoryName"`
	LastUpdateEmpid     string           `position:"Body" name:"LastUpdateEmpid"`
	BaseMeAgentId       requests.Integer `position:"Query" name:"BaseMeAgentId"`
	TypeName            string           `position:"Body" name:"TypeName"`
	RequireInfos        *[]string        `position:"Body" name:"RequireInfos"  type:"Repeated"`
	Status              requests.Integer `position:"Body" name:"Status"`
}

// ListRulesV4Response is the response struct for api ListRulesV4
type ListRulesV4Response struct {
	*responses.BaseResponse
	TotalCount     int                     `json:"TotalCount" xml:"TotalCount"`
	BusinessType   int                     `json:"BusinessType" xml:"BusinessType"`
	Count          int                     `json:"Count" xml:"Count"`
	CurrentPage    int                     `json:"CurrentPage" xml:"CurrentPage"`
	PageSize       int                     `json:"PageSize" xml:"PageSize"`
	PageNumber     int                     `json:"PageNumber" xml:"PageNumber"`
	RequestId      string                  `json:"RequestId" xml:"RequestId"`
	Success        bool                    `json:"Success" xml:"Success"`
	Code           string                  `json:"Code" xml:"Code"`
	Message        string                  `json:"Message" xml:"Message"`
	HttpStatusCode int                     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       []string                `json:"Messages" xml:"Messages"`
	Data           []DataItemInListRulesV4 `json:"Data" xml:"Data"`
}

// CreateListRulesV4Request creates a request to invoke ListRulesV4 API
func CreateListRulesV4Request() (request *ListRulesV4Request) {
	request = &ListRulesV4Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListRulesV4", "", "")
	request.Method = requests.POST
	return
}

// CreateListRulesV4Response creates a response to parse from ListRulesV4 response
func CreateListRulesV4Response() (response *ListRulesV4Response) {
	response = &ListRulesV4Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
