package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryByInstanceInfo invokes the qianzhou.QueryByInstanceInfo API synchronously
func (client *Client) QueryByInstanceInfo(request *QueryByInstanceInfoRequest) (response *QueryByInstanceInfoResponse, err error) {
	response = CreateQueryByInstanceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryByInstanceInfoWithChan invokes the qianzhou.QueryByInstanceInfo API asynchronously
func (client *Client) QueryByInstanceInfoWithChan(request *QueryByInstanceInfoRequest) (<-chan *QueryByInstanceInfoResponse, <-chan error) {
	responseChan := make(chan *QueryByInstanceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryByInstanceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryByInstanceInfoWithCallback invokes the qianzhou.QueryByInstanceInfo API asynchronously
func (client *Client) QueryByInstanceInfoWithCallback(request *QueryByInstanceInfoRequest, callback func(response *QueryByInstanceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryByInstanceInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryByInstanceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryByInstanceInfoRequest is the request struct for api QueryByInstanceInfo
type QueryByInstanceInfoRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// QueryByInstanceInfoResponse is the response struct for api QueryByInstanceInfo
type QueryByInstanceInfoResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"requestId" xml:"requestId"`
	Code      int        `json:"code" xml:"code"`
	Msg       string     `json:"msg" xml:"msg"`
	Data      []DataItem `json:"data" xml:"data"`
}

// CreateQueryByInstanceInfoRequest creates a request to invoke QueryByInstanceInfo API
func CreateQueryByInstanceInfoRequest() (request *QueryByInstanceInfoRequest) {
	request = &QueryByInstanceInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "QueryByInstanceInfo", "/popapi/queryByInstanceInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryByInstanceInfoResponse creates a response to parse from QueryByInstanceInfo response
func CreateQueryByInstanceInfoResponse() (response *QueryByInstanceInfoResponse) {
	response = &QueryByInstanceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
