package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCustomLineInfo invokes the pvtz.DescribeCustomLineInfo API synchronously
func (client *Client) DescribeCustomLineInfo(request *DescribeCustomLineInfoRequest) (response *DescribeCustomLineInfoResponse, err error) {
	response = CreateDescribeCustomLineInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCustomLineInfoWithChan invokes the pvtz.DescribeCustomLineInfo API asynchronously
func (client *Client) DescribeCustomLineInfoWithChan(request *DescribeCustomLineInfoRequest) (<-chan *DescribeCustomLineInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeCustomLineInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCustomLineInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCustomLineInfoWithCallback invokes the pvtz.DescribeCustomLineInfo API asynchronously
func (client *Client) DescribeCustomLineInfoWithCallback(request *DescribeCustomLineInfoRequest, callback func(response *DescribeCustomLineInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCustomLineInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeCustomLineInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCustomLineInfoRequest is the request struct for api DescribeCustomLineInfo
type DescribeCustomLineInfoRequest struct {
	*requests.RpcRequest
	LineId       string `position:"Query" name:"LineId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeCustomLineInfoResponse is the response struct for api DescribeCustomLineInfo
type DescribeCustomLineInfoResponse struct {
	*responses.BaseResponse
	RequestId       string   `json:"RequestId" xml:"RequestId"`
	LineId          string   `json:"LineId" xml:"LineId"`
	Name            string   `json:"Name" xml:"Name"`
	Creator         string   `json:"Creator" xml:"Creator"`
	CreatorType     string   `json:"CreatorType" xml:"CreatorType"`
	CreatorSubType  string   `json:"CreatorSubType" xml:"CreatorSubType"`
	CreateTime      string   `json:"CreateTime" xml:"CreateTime"`
	UpdateTime      string   `json:"UpdateTime" xml:"UpdateTime"`
	CreateTimestamp int64    `json:"CreateTimestamp" xml:"CreateTimestamp"`
	UpdateTimestamp int64    `json:"UpdateTimestamp" xml:"UpdateTimestamp"`
	Ipv4s           []string `json:"Ipv4s" xml:"Ipv4s"`
}

// CreateDescribeCustomLineInfoRequest creates a request to invoke DescribeCustomLineInfo API
func CreateDescribeCustomLineInfoRequest() (request *DescribeCustomLineInfoRequest) {
	request = &DescribeCustomLineInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeCustomLineInfo", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCustomLineInfoResponse creates a response to parse from DescribeCustomLineInfo response
func CreateDescribeCustomLineInfoResponse() (response *DescribeCustomLineInfoResponse) {
	response = &DescribeCustomLineInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
