package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserVpcVSwitch invokes the pts.GetUserVpcVSwitch API synchronously
func (client *Client) GetUserVpcVSwitch(request *GetUserVpcVSwitchRequest) (response *GetUserVpcVSwitchResponse, err error) {
	response = CreateGetUserVpcVSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserVpcVSwitchWithChan invokes the pts.GetUserVpcVSwitch API asynchronously
func (client *Client) GetUserVpcVSwitchWithChan(request *GetUserVpcVSwitchRequest) (<-chan *GetUserVpcVSwitchResponse, <-chan error) {
	responseChan := make(chan *GetUserVpcVSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserVpcVSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserVpcVSwitchWithCallback invokes the pts.GetUserVpcVSwitch API asynchronously
func (client *Client) GetUserVpcVSwitchWithCallback(request *GetUserVpcVSwitchRequest, callback func(response *GetUserVpcVSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserVpcVSwitchResponse
		var err error
		defer close(result)
		response, err = client.GetUserVpcVSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserVpcVSwitchRequest is the request struct for api GetUserVpcVSwitch
type GetUserVpcVSwitchRequest struct {
	*requests.RpcRequest
	VpcId      string           `position:"Query" name:"VpcId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// GetUserVpcVSwitchResponse is the response struct for api GetUserVpcVSwitch
type GetUserVpcVSwitchResponse struct {
	*responses.BaseResponse
	VSwitchCount   int       `json:"VSwitchCount" xml:"VSwitchCount"`
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	Message        string    `json:"Message" xml:"Message"`
	PageSize       int       `json:"PageSize" xml:"PageSize"`
	PageNumber     int       `json:"PageNumber" xml:"PageNumber"`
	HttpStatusCode int       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string    `json:"Code" xml:"Code"`
	Success        bool      `json:"Success" xml:"Success"`
	VSwitchList    []VSwitch `json:"VSwitchList" xml:"VSwitchList"`
}

// CreateGetUserVpcVSwitchRequest creates a request to invoke GetUserVpcVSwitch API
func CreateGetUserVpcVSwitchRequest() (request *GetUserVpcVSwitchRequest) {
	request = &GetUserVpcVSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "GetUserVpcVSwitch", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUserVpcVSwitchResponse creates a response to parse from GetUserVpcVSwitch response
func CreateGetUserVpcVSwitchResponse() (response *GetUserVpcVSwitchResponse) {
	response = &GetUserVpcVSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
