package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBClusterServerlessConf invokes the polardb.ModifyDBClusterServerlessConf API synchronously
func (client *Client) ModifyDBClusterServerlessConf(request *ModifyDBClusterServerlessConfRequest) (response *ModifyDBClusterServerlessConfResponse, err error) {
	response = CreateModifyDBClusterServerlessConfResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBClusterServerlessConfWithChan invokes the polardb.ModifyDBClusterServerlessConf API asynchronously
func (client *Client) ModifyDBClusterServerlessConfWithChan(request *ModifyDBClusterServerlessConfRequest) (<-chan *ModifyDBClusterServerlessConfResponse, <-chan error) {
	responseChan := make(chan *ModifyDBClusterServerlessConfResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBClusterServerlessConf(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBClusterServerlessConfWithCallback invokes the polardb.ModifyDBClusterServerlessConf API asynchronously
func (client *Client) ModifyDBClusterServerlessConfWithCallback(request *ModifyDBClusterServerlessConfRequest, callback func(response *ModifyDBClusterServerlessConfResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBClusterServerlessConfResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBClusterServerlessConf(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBClusterServerlessConfRequest is the request struct for api ModifyDBClusterServerlessConf
type ModifyDBClusterServerlessConfRequest struct {
	*requests.RpcRequest
	ScaleRoNumMax                     string           `position:"Query" name:"ScaleRoNumMax"`
	ResourceOwnerId                   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServerlessRuleMode                string           `position:"Query" name:"ServerlessRuleMode"`
	ScaleApRoNumMax                   string           `position:"Query" name:"ScaleApRoNumMax"`
	ScaleMax                          string           `position:"Query" name:"ScaleMax"`
	PlannedEndTime                    string           `position:"Query" name:"PlannedEndTime"`
	ServerlessRuleCpuEnlargeThreshold string           `position:"Query" name:"ServerlessRuleCpuEnlargeThreshold"`
	SecondsUntilAutoPause             string           `position:"Query" name:"SecondsUntilAutoPause"`
	ScaleApRoNumMin                   string           `position:"Query" name:"ScaleApRoNumMin"`
	TaskId                            string           `position:"Query" name:"TaskId"`
	ScaleMin                          string           `position:"Query" name:"ScaleMin"`
	CrontabJobId                      string           `position:"Query" name:"CrontabJobId"`
	ResourceOwnerAccount              string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId                       string           `position:"Query" name:"DBClusterId"`
	OwnerAccount                      string           `position:"Query" name:"OwnerAccount"`
	ServerlessRuleCpuShrinkThreshold  string           `position:"Query" name:"ServerlessRuleCpuShrinkThreshold"`
	OwnerId                           requests.Integer `position:"Query" name:"OwnerId"`
	PlannedStartTime                  string           `position:"Query" name:"PlannedStartTime"`
	ScaleRoNumMin                     string           `position:"Query" name:"ScaleRoNumMin"`
	AllowShutDown                     string           `position:"Query" name:"AllowShutDown"`
	FromTimeService                   requests.Boolean `position:"Query" name:"FromTimeService"`
}

// ModifyDBClusterServerlessConfResponse is the response struct for api ModifyDBClusterServerlessConf
type ModifyDBClusterServerlessConfResponse struct {
	*responses.BaseResponse
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBClusterServerlessConfRequest creates a request to invoke ModifyDBClusterServerlessConf API
func CreateModifyDBClusterServerlessConfRequest() (request *ModifyDBClusterServerlessConfRequest) {
	request = &ModifyDBClusterServerlessConfRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ModifyDBClusterServerlessConf", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBClusterServerlessConfResponse creates a response to parse from ModifyDBClusterServerlessConf response
func CreateModifyDBClusterServerlessConfResponse() (response *ModifyDBClusterServerlessConfResponse) {
	response = &ModifyDBClusterServerlessConfResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
