package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDBClusterServerless invokes the polardb.DisableDBClusterServerless API synchronously
func (client *Client) DisableDBClusterServerless(request *DisableDBClusterServerlessRequest) (response *DisableDBClusterServerlessResponse, err error) {
	response = CreateDisableDBClusterServerlessResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDBClusterServerlessWithChan invokes the polardb.DisableDBClusterServerless API asynchronously
func (client *Client) DisableDBClusterServerlessWithChan(request *DisableDBClusterServerlessRequest) (<-chan *DisableDBClusterServerlessResponse, <-chan error) {
	responseChan := make(chan *DisableDBClusterServerlessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDBClusterServerless(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDBClusterServerlessWithCallback invokes the polardb.DisableDBClusterServerless API asynchronously
func (client *Client) DisableDBClusterServerlessWithCallback(request *DisableDBClusterServerlessRequest, callback func(response *DisableDBClusterServerlessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDBClusterServerlessResponse
		var err error
		defer close(result)
		response, err = client.DisableDBClusterServerless(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDBClusterServerlessRequest is the request struct for api DisableDBClusterServerless
type DisableDBClusterServerlessRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DisableDBClusterServerlessResponse is the response struct for api DisableDBClusterServerless
type DisableDBClusterServerlessResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
}

// CreateDisableDBClusterServerlessRequest creates a request to invoke DisableDBClusterServerless API
func CreateDisableDBClusterServerlessRequest() (request *DisableDBClusterServerlessRequest) {
	request = &DisableDBClusterServerlessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DisableDBClusterServerless", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableDBClusterServerlessResponse creates a response to parse from DisableDBClusterServerless response
func CreateDisableDBClusterServerlessResponse() (response *DisableDBClusterServerlessResponse) {
	response = &DisableDBClusterServerlessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
