package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDatabaseBackup invokes the petadata.DescribeDatabaseBackup API synchronously
// api document: https://help.aliyun.com/api/petadata/describedatabasebackup.html
func (client *Client) DescribeDatabaseBackup(request *DescribeDatabaseBackupRequest) (response *DescribeDatabaseBackupResponse, err error) {
	response = CreateDescribeDatabaseBackupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDatabaseBackupWithChan invokes the petadata.DescribeDatabaseBackup API asynchronously
// api document: https://help.aliyun.com/api/petadata/describedatabasebackup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDatabaseBackupWithChan(request *DescribeDatabaseBackupRequest) (<-chan *DescribeDatabaseBackupResponse, <-chan error) {
	responseChan := make(chan *DescribeDatabaseBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDatabaseBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDatabaseBackupWithCallback invokes the petadata.DescribeDatabaseBackup API asynchronously
// api document: https://help.aliyun.com/api/petadata/describedatabasebackup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDatabaseBackupWithCallback(request *DescribeDatabaseBackupRequest, callback func(response *DescribeDatabaseBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDatabaseBackupResponse
		var err error
		defer close(result)
		response, err = client.DescribeDatabaseBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDatabaseBackupRequest is the request struct for api DescribeDatabaseBackup
type DescribeDatabaseBackupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	BackupId             string           `position:"Query" name:"BackupId"`
	EndTime              string           `position:"Query" name:"EndTime"`
	StartTime            string           `position:"Query" name:"StartTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           string           `position:"Query" name:"PageNumber"`
	BackupStatus         string           `position:"Query" name:"BackupStatus"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	DBName               string           `position:"Query" name:"DBName"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	PageSize             string           `position:"Query" name:"PageSize"`
	BackupMode           string           `position:"Query" name:"BackupMode"`
}

// DescribeDatabaseBackupResponse is the response struct for api DescribeDatabaseBackup
type DescribeDatabaseBackupResponse struct {
	*responses.BaseResponse
	RequestId        string      `json:"RequestId" xml:"RequestId"`
	InstanceId       string      `json:"InstanceId" xml:"InstanceId"`
	DBName           string      `json:"DBName" xml:"DBName"`
	PageNumber       int         `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int         `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount int         `json:"TotalRecordCount" xml:"TotalRecordCount"`
	BackupTotalSize  int         `json:"BackupTotalSize" xml:"BackupTotalSize"`
	BackupItems      BackupItems `json:"BackupItems" xml:"BackupItems"`
}

// CreateDescribeDatabaseBackupRequest creates a request to invoke DescribeDatabaseBackup API
func CreateDescribeDatabaseBackupRequest() (request *DescribeDatabaseBackupRequest) {
	request = &DescribeDatabaseBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "DescribeDatabaseBackup", "petadata", "openAPI")
	return
}

// CreateDescribeDatabaseBackupResponse creates a response to parse from DescribeDatabaseBackup response
func CreateDescribeDatabaseBackupResponse() (response *DescribeDatabaseBackupResponse) {
	response = &DescribeDatabaseBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
