package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTrafficControlTarget invokes the pairecservice.GetTrafficControlTarget API synchronously
func (client *Client) GetTrafficControlTarget(request *GetTrafficControlTargetRequest) (response *GetTrafficControlTargetResponse, err error) {
	response = CreateGetTrafficControlTargetResponse()
	err = client.DoAction(request, response)
	return
}

// GetTrafficControlTargetWithChan invokes the pairecservice.GetTrafficControlTarget API asynchronously
func (client *Client) GetTrafficControlTargetWithChan(request *GetTrafficControlTargetRequest) (<-chan *GetTrafficControlTargetResponse, <-chan error) {
	responseChan := make(chan *GetTrafficControlTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTrafficControlTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTrafficControlTargetWithCallback invokes the pairecservice.GetTrafficControlTarget API asynchronously
func (client *Client) GetTrafficControlTargetWithCallback(request *GetTrafficControlTargetRequest, callback func(response *GetTrafficControlTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTrafficControlTargetResponse
		var err error
		defer close(result)
		response, err = client.GetTrafficControlTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTrafficControlTargetRequest is the request struct for api GetTrafficControlTarget
type GetTrafficControlTargetRequest struct {
	*requests.RoaRequest
	TrafficControlTargetId string `position:"Path" name:"TrafficControlTargetId"`
	InstanceId             string `position:"Query" name:"InstanceId"`
}

// GetTrafficControlTargetResponse is the response struct for api GetTrafficControlTarget
type GetTrafficControlTargetResponse struct {
	*responses.BaseResponse
	RequestId              string     `json:"RequestId" xml:"RequestId"`
	TrafficControlTargetId string     `json:"TrafficControlTargetId" xml:"TrafficControlTargetId"`
	Name                   string     `json:"Name" xml:"Name"`
	StartTime              string     `json:"StartTime" xml:"StartTime"`
	EndTime                string     `json:"EndTime" xml:"EndTime"`
	ItemConditionType      string     `json:"ItemConditionType" xml:"ItemConditionType"`
	ItemConditionArray     string     `json:"ItemConditionArray" xml:"ItemConditionArray"`
	ItemConditionExpress   string     `json:"ItemConditionExpress" xml:"ItemConditionExpress"`
	Event                  string     `json:"Event" xml:"Event"`
	Value                  float64    `json:"Value" xml:"Value"`
	StatisPeriod           string     `json:"StatisPeriod" xml:"StatisPeriod"`
	ToleranceValue         int64      `json:"ToleranceValue" xml:"ToleranceValue"`
	RecallName             string     `json:"RecallName" xml:"RecallName"`
	Status                 string     `json:"Status" xml:"Status"`
	GmtCreateTime          string     `json:"GmtCreateTime" xml:"GmtCreateTime"`
	NewProductRegulation   bool       `json:"NewProductRegulation" xml:"NewProductRegulation"`
	SplitParts             SplitParts `json:"SplitParts" xml:"SplitParts"`
}

// CreateGetTrafficControlTargetRequest creates a request to invoke GetTrafficControlTarget API
func CreateGetTrafficControlTargetRequest() (request *GetTrafficControlTargetRequest) {
	request = &GetTrafficControlTargetRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetTrafficControlTarget", "/api/v1/trafficcontroltargets/[TrafficControlTargetId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetTrafficControlTargetResponse creates a response to parse from GetTrafficControlTarget response
func CreateGetTrafficControlTargetResponse() (response *GetTrafficControlTargetResponse) {
	response = &GetTrafficControlTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
